/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.part;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.directedit.locator.TextCellEditorLocator;
import org.eclipse.papyrus.uml.diagram.activity.edit.parts.DecisionInputEditPart;
import org.eclipse.papyrus.uml.diagram.activity.figures.LinkAndCornerBentWithTextFigure;
import org.eclipse.papyrus.uml.diagram.common.directedit.MultilineLabelDirectEditManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.DecisionNode;

public class CustomDecisionInputEditPart
extends DecisionInputEditPart {
    private DirectEditManager manager;

    public CustomDecisionInputEditPart(View view) {
        super(view);
    }

    protected String getLabelTextHelper(IFigure figure) {
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            return ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getText();
        }
        return super.getLabelTextHelper(figure);
    }

    protected void setLabelTextHelper(IFigure figure, String text) {
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setText(text);
        } else {
            super.setLabelTextHelper(figure, text);
        }
    }

    protected Image getLabelIconHelper(IFigure figure) {
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            return ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().getIcon();
        }
        return this.getLabelIconHelper(figure);
    }

    protected void setLabelIconHelper(IFigure figure, Image icon) {
        if (figure instanceof LinkAndCornerBentWithTextFigure) {
            ((LinkAndCornerBentWithTextFigure)figure).getCornerBentContent().setIcon(icon);
        } else {
            super.setLabelIconHelper(figure, icon);
        }
    }

    protected String getLabelText() {
        if (this.isDecisionInputSet()) {
            return super.getLabelText();
        }
        return "";
    }

    public String getEditText() {
        if (!this.isDecisionInputSet()) {
            return "";
        }
        return super.getEditText();
    }

    protected void performDirectEdit() {
        if (this.isDecisionInputSet()) {
            this.getManager().show();
        }
    }

    protected void performDirectEdit(Point eventLocation) {
        if (this.isDecisionInputSet()) {
            super.performDirectEdit(eventLocation);
        }
    }

    protected void performDirectEdit(char initialCharacter) {
        if (this.isDecisionInputSet()) {
            super.performDirectEdit(initialCharacter);
        } else {
            this.performDirectEdit();
        }
    }

    protected void performDirectEditRequest(Request request) {
        if (!this.isDecisionInputSet()) {
            return;
        }
        super.performDirectEditRequest(request);
    }

    private boolean isDecisionInputSet() {
        return ((DecisionNode)this.resolveSemanticElement()).getDecisionInput() != null;
    }

    protected void setVisibility(boolean vis) {
        Behavior decisionInput;
        EObject element = this.resolveSemanticElement();
        if (element instanceof DecisionNode && (decisionInput = ((DecisionNode)element).getDecisionInput()) == null) {
            vis = false;
        }
        super.setVisibility(vis);
    }

    protected void refreshLabel() {
        this.refreshVisibility();
    }

    protected DirectEditManager getManager() {
        if (this.manager == null) {
            this.setManager((DirectEditManager)new MultilineLabelDirectEditManager((GraphicalEditPart)this, MultilineLabelDirectEditManager.getTextCellEditorClass((GraphicalEditPart)this), (CellEditorLocator)new TextCellEditorLocator((WrappingLabel)((LinkAndCornerBentWithTextFigure)this.getFigure()).getCornerBentContent())));
        }
        return this.manager;
    }

    protected void setManager(DirectEditManager manager) {
        this.manager = manager;
    }
}

