/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.search.ui.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.search.ui.validator.IParticipantValidator;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ParticipantValidator
implements IParticipantValidator {
    private static ParticipantValidator instance = null;

    private ParticipantValidator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final ParticipantValidator getInstance() {
        if (instance != null) return instance;
        Class<ParticipantValidator> clazz = ParticipantValidator.class;
        synchronized (ParticipantValidator.class) {
            if (instance != null) return instance;
            instance = new ParticipantValidator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public Collection<EObject> getParticipants(EObject root, Object[] participantsTypes) {
        List<Object> participantsTypesList = Arrays.asList(participantsTypes);
        ArrayList<EObject> results = new ArrayList<EObject>();
        TreeIterator it = root.eAllContents();
        while (it.hasNext()) {
            EObject modelElement = (EObject)it.next();
            EClass e = modelElement.eClass();
            if (!participantsTypesList.contains(modelElement.eClass())) continue;
            results.add(modelElement);
        }
        return results;
    }

    public Collection<EObject> getParticipantsStereotype(EList<EObject> contents, Object[] participantsTypes) {
        List<Object> participantsTypesList = Arrays.asList(participantsTypes);
        ArrayList<EObject> results = new ArrayList<EObject>();
        block0: for (EObject content : contents) {
            Element umlElement;
            if (content instanceof Model || !((umlElement = UMLUtil.getBaseElement((EObject)content)) instanceof Element)) continue;
            Object[] objectArray = participantsTypes;
            int n = participantsTypes.length;
            int n2 = 0;
            while (n2 < n) {
                Object participantStereotype = objectArray[n2];
                if (participantStereotype instanceof Stereotype && StereotypeUtil.isApplied((Element)umlElement, (String)((Stereotype)participantStereotype).getQualifiedName())) {
                    results.add((EObject)umlElement);
                    continue block0;
                }
                ++n2;
            }
        }
        return results;
    }
}

