/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.kernel.scheduling.execution;

import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecution;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.ITaskExecutionCondition;
import org.eclipse.papyrus.moka.kernel.scheduling.execution.TaskExecutionStatus;

public abstract class TaskExecution
implements ITaskExecution {
    protected TaskExecutionStatus status = TaskExecutionStatus.NONE;
    protected ReentrantLock statusLock = new ReentrantLock(true);

    @Override
    public TaskExecutionStatus getStatus() {
        this.statusLock.lock();
        TaskExecutionStatus s = this.status;
        this.statusLock.unlock();
        return s;
    }

    @Override
    public void setStatus(TaskExecutionStatus s) {
        this.statusLock.lock();
        this.status = s;
        this.statusLock.unlock();
    }

    @Override
    public boolean canExecute() {
        return true;
    }

    @Override
    public void terminate(ITaskExecutionCondition condition) {
        if (condition.evaluate(this)) {
            this.terminate();
        }
    }

    @Override
    public void suspend(ITaskExecutionCondition condition) {
        if (condition.evaluate(this)) {
            this.suspend();
        }
    }

    @Override
    public void resume(ITaskExecutionCondition condition) {
        if (condition.evaluate(this)) {
            this.resume();
        }
    }
}

