/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.fuml.validation.constraints;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.AcceptCallAction;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.Trigger;

public class FumlAcceptEventReceiveAllTriggeringSignalsConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        AcceptEventAction acceptEventAction = (AcceptEventAction)ctx.getTarget();
        if (!(acceptEventAction instanceof AcceptCallAction) && acceptEventAction.getContext() instanceof Class) {
            Class cls = (Class)acceptEventAction.getContext();
            List classes = cls.allParents().stream().filter(c -> c instanceof Class).map(c -> (Class)Class.class.cast(c)).collect(Collectors.toList());
            HashSet<Signal> contextReceptionSignals = new HashSet<Signal>();
            for (Class clazz : classes) {
                for (Reception reception : clazz.getOwnedReceptions()) {
                    contextReceptionSignals.add(reception.getSignal());
                }
            }
            for (Reception reception : cls.getOwnedReceptions()) {
                contextReceptionSignals.add(reception.getSignal());
            }
            HashSet<Signal> triggerSignals = new HashSet<Signal>();
            for (Trigger trigger : acceptEventAction.getTriggers()) {
                if (!(trigger.getEvent() instanceof SignalEvent)) continue;
                triggerSignals.add(((SignalEvent)trigger.getEvent()).getSignal());
            }
            if (!contextReceptionSignals.containsAll(triggerSignals)) {
                return ctx.createFailureStatus(new Object[]{"AcceptEventAction - Unless the action is an accept call action, the context class must have receptions for all triggering signals."});
            }
        }
        return ctx.createSuccessStatus();
    }
}

