/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.engine.uml.debug.service;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.moka.debug.engine.DebugServiceHelper;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngine;
import org.eclipse.papyrus.moka.debug.engine.IDebuggableExecutionEngineThread;
import org.eclipse.papyrus.moka.debug.service.DebugService;
import org.eclipse.papyrus.moka.engine.uml.debug.service.DebugServiceUtils;
import org.eclipse.papyrus.moka.engine.uml.debug.service.UMLDebuggableExecutionEngineThread;
import org.eclipse.papyrus.moka.fuml.loci.ISemanticVisitor;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.ISemanticVisitorExecutionListener;
import org.eclipse.papyrus.moka.fuml.profiling.listeners.IValueLifecyleListener;
import org.eclipse.papyrus.moka.fuml.simpleclassifiers.IValue;
import org.eclipse.papyrus.moka.fuml.structuredclassifiers.IObject_;
import org.eclipse.papyrus.moka.kernel.SuspensionReasons;
import org.eclipse.papyrus.moka.kernel.assistant.Suspension;

public class UMLDebugService
extends DebugService<IObject_, ISemanticVisitor>
implements ISemanticVisitorExecutionListener,
IValueLifecyleListener {
    protected Set<String> debugAssistants = new HashSet<String>();

    public void nodeVisited(ISemanticVisitor visitor) {
        IObject_ context = DebugServiceUtils.getExecutionContext(visitor);
        IDebuggableExecutionEngineThread debuggableThread = null;
        if (context != null) {
            debuggableThread = ((IDebuggableExecutionEngine)this.engine).getThread(context.getIdentifier());
            if (debuggableThread != null) {
                debuggableThread.setSuspensionContext((Object)visitor);
            }
            if (this.shouldEngineSuspend()) {
                this.engineSuspendRequestLock.lock();
                this.enginSuspendRequest = false;
                this.engineSuspendRequestLock.unlock();
                this.suspendEngine();
            } else if (this.shouldEngineTerminate()) {
                this.engineTerminateRequestLock.lock();
                this.engineTerminateRequest = false;
                this.engineTerminateRequestLock.unlock();
                this.terminateEngine();
            } else if (debuggableThread != null) {
                if (DebugServiceHelper.INSTANCE.hasBreakpoint(visitor)) {
                    this.client.fireSuspendThreadEvent(context, visitor, SuspensionReasons.BREAKPOINT);
                    this.suspendThread(debuggableThread);
                } else {
                    this.threadSuspendRequestLock.lock();
                    Boolean flag = (Boolean)this.threadSuspendRequest.get(context.getIdentifier());
                    if (flag != null && flag.booleanValue()) {
                        this.threadSuspendRequestLock.unlock();
                        this.suspendThread(debuggableThread);
                    } else {
                        this.threadSuspendRequestLock.unlock();
                        this.threadTerminateRequestLock.lock();
                        if (this.threadTerminateRequest.contains(context.getIdentifier())) {
                            this.terminateThread(debuggableThread);
                        }
                        this.threadTerminateRequestLock.unlock();
                    }
                }
            }
        }
    }

    public void nodeSuspended(ISemanticVisitor visitor, Suspension suspension) {
        IObject_ context = DebugServiceUtils.getExecutionContext(visitor);
        if (context != null) {
            this.client.fireSuspendThreadEvent(context, visitor, suspension.getSuspensionReason());
            IDebuggableExecutionEngineThread thread = ((IDebuggableExecutionEngine)this.engine).getThread(context.getIdentifier());
            if (thread != null) {
                thread.setSuspensionContext((Object)visitor);
                this.suspendThread(thread);
            }
        }
    }

    public void nodeLeft(ISemanticVisitor visitor) {
    }

    public void valueCreated(IValue value) {
        if (value instanceof IObject_ && DebugServiceUtils.isActive((IObject_)value)) {
            ((IDebuggableExecutionEngine)this.engine).addDebugThread((IDebuggableExecutionEngineThread)new UMLDebuggableExecutionEngineThread((IObject_)value));
            this.client.fireNewThreadEvent((IObject_)value);
        }
    }

    public void valueDestroyed(IValue value) {
        if (value instanceof IObject_ && DebugServiceUtils.isActive((IObject_)value)) {
            ((IDebuggableExecutionEngine)this.engine).removeDebugThread((IDebuggableExecutionEngineThread)new UMLDebuggableExecutionEngineThread((IObject_)value));
            this.client.fireTerminateThreadEvent((IObject_)value);
        }
    }

    protected void initDebugAssistant() {
        this.debugAssistants.add("org.eclipse.papyrus.moka.fuml.profiling.debug.NullStructuredValueProfiler");
        this.debugAssistants.add("org.eclipse.papyrus.moka.fuml.profiling.debug.NullTokenPropagationProfiler");
        this.debugAssistants.add("org.eclipse.papyrus.moka.pscs.profiling.debug.NullStructuredValueProfiler");
    }

    public boolean shouldContinueInDebugAssistant(String assistantID) {
        return this.debugAssistants.contains(assistantID);
    }
}

