/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.dev.types.providers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.ClientContextManager;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.SpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.IEditHelperAdvice;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.types.core.utils.AdviceUtil;

public class ElementTypesDetailsContentProvider
implements ITreeContentProvider {
    String contextID;
    String typeID;

    public void setContextID(String contextID) {
        this.contextID = contextID;
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (inputElement instanceof IElementType) {
            if (inputElement instanceof IHintedType) {
                result.add("Semantic Hint: " + ((IHintedType)inputElement).getSemanticHint());
            } else {
                result.add("Not Hinted");
            }
            if (inputElement instanceof SpecializationType) {
                String[] stringArray = ((SpecializationType)inputElement).getSpecializedTypeIds();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String id = stringArray[n2];
                    result.add("SpecializedType Id: " + id);
                    ++n2;
                }
                if (((SpecializationType)inputElement).getEditHelperAdvice() != null) {
                    result.add("EditHelperAdvice: " + ((SpecializationType)inputElement).getEditHelperAdvice().getClass().getName());
                } else {
                    result.add("EditHelperAdvice: None");
                }
                if (((SpecializationType)inputElement).getEContainerDescriptor() != null) {
                    Object eReferences = "";
                    EReference[] eReferenceArray = ((SpecializationType)inputElement).getEContainerDescriptor().getContainmentFeatures();
                    int n3 = eReferenceArray.length;
                    n = 0;
                    while (n < n3) {
                        EReference eReference = eReferenceArray[n];
                        eReferences = (String)eReferences + EMFCoreUtil.getQualifiedName((EObject)eReference, (boolean)true) + " ";
                        ++n;
                    }
                    result.add("EContainerDescriptor: " + (String)eReferences);
                } else {
                    result.add("EContainerDescriptor: None");
                }
            }
            if (((IElementType)inputElement).getEditHelper() != null) {
                result.add("EditHelper: " + ((IElementType)inputElement).getEditHelper().getClass().getName());
            } else {
                result.add("EditHelper: None");
            }
            if (((IElementType)inputElement).getEClass() != null) {
                result.add("Eclass: " + EMFCoreUtil.getQualifiedName((EObject)((IElementType)inputElement).getEClass(), (boolean)true));
            } else {
                result.add("Eclass: None");
            }
            result.add("Display Name: " + ((IElementType)inputElement).getDisplayName());
            IEditHelperAdvice[] advices = ElementTypeRegistry.getInstance().getEditHelperAdvice((IElementType)inputElement, ClientContextManager.getInstance().getClientContext(this.contextID));
            result.add(Arrays.asList(advices));
        }
        return result.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof List) {
            IEditHelperAdvice[] parents = new IEditHelperAdvice[((List)parentElement).size()];
            ((List)parentElement).toArray(parents);
            Object[] sortedAdvices = AdviceUtil.sort((IEditHelperAdvice[])parents, (IElementType)ElementTypeRegistry.getInstance().getType(this.typeID), (String)this.contextID);
            return sortedAdvices;
        }
        return Collections.emptyList().toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length != 0;
    }
}

