/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.debug.views;

import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.graphics.ColorRegistry;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.papyrus.infra.emf.Activator;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.configuration.handler.GMFToCSSConverter;
import org.eclipse.papyrus.infra.gmfdiag.css.dom.GMFElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.ForceValueHelper;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.ColorTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.CssTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IdentifierTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.IntegerTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.NumberTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.StringTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.SymbolTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.UrlTok;
import org.eclipse.papyrus.infra.gmfdiag.css3.cSS.util.CSSSwitch;
import org.eclipse.papyrus.infra.services.labelprovider.service.impl.LabelProviderServiceImpl;
import org.eclipse.papyrus.infra.widgets.providers.CollectionContentProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.w3c.dom.Element;

public class CSSDebugView
extends ViewPart
implements ISelectionListener,
ISelectionChangedListener {
    private Composite viewParent;
    private TreeViewer treeViewer;
    private Composite viewComposite;
    private Composite viewPropertiesComposite;
    private Composite viewDescriptionComposite;
    private TableViewer semanticProperties;
    private TableViewer notationProperties;

    public void createPartControl(Composite parent) {
        this.viewParent = new Composite(parent, 0);
        this.viewParent.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer(this.viewParent, 2048);
        this.treeViewer.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderServiceImpl().getLabelProvider());
        GridData treeLayoutData = new GridData(1, 4, false, true);
        treeLayoutData.minimumWidth = 250;
        treeLayoutData.widthHint = 250;
        this.treeViewer.getTree().setLayoutData((Object)treeLayoutData);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewComposite = new Composite(this.viewParent, 2048);
        this.viewComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.viewComposite.setLayout((Layout)new GridLayout(2, true));
        this.viewDescriptionComposite = new Composite(this.viewComposite, 0);
        GridLayout viewDescriptionCompositeLayout = new GridLayout(2, false);
        viewDescriptionCompositeLayout.marginHeight = 0;
        viewDescriptionCompositeLayout.marginWidth = 0;
        this.viewDescriptionComposite.setLayout((Layout)viewDescriptionCompositeLayout);
        this.viewDescriptionComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.viewPropertiesComposite = new Composite(this.viewComposite, 0);
        GridLayout viewPropertiesCompositeLayout = new GridLayout(2, false);
        viewPropertiesCompositeLayout.marginHeight = 0;
        viewPropertiesCompositeLayout.marginWidth = 0;
        this.viewPropertiesComposite.setLayout((Layout)viewPropertiesCompositeLayout);
        this.viewPropertiesComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Label notationPropertiesHeader = new Label(this.viewComposite, 0);
        notationPropertiesHeader.setText("Notation properties:");
        notationPropertiesHeader.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.notationProperties = new TableViewer(this.viewComposite, 2048);
        this.notationProperties.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.notationProperties.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.createColumn(this.notationProperties, "Property");
        this.createColumn(this.notationProperties, "Value source");
        this.createColumn(this.notationProperties, "Value");
        Label semanticPropertiesHeader = new Label(this.viewComposite, 0);
        semanticPropertiesHeader.setText("Semantic properties:");
        semanticPropertiesHeader.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.semanticProperties = new TableViewer(this.viewComposite, 2048);
        this.semanticProperties.getTable().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.semanticProperties.setContentProvider((IContentProvider)CollectionContentProvider.instance);
        this.createColumn(this.semanticProperties, "Property");
        this.createColumn(this.semanticProperties, "Value");
        this.getViewSite().getPage().addSelectionListener((ISelectionListener)this);
    }

    private void createColumn(TableViewer viewer, String label) {
        viewer.getTable().setHeaderVisible(true);
        TableColumn column = new TableColumn(viewer.getTable(), 0);
        column.setText(label);
        column.setWidth(150);
    }

    public void setFocus() {
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List<Object> supportedElements = this.getElementsWithCSSSupport(structuredSelection);
            if (supportedElements.isEmpty()) {
                return;
            }
            this.clean();
            this.debug(supportedElements);
        }
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    private List<Object> getElementsWithCSSSupport(IStructuredSelection fromSelection) {
        Iterator selectionIterator = fromSelection.iterator();
        LinkedList<Object> result = new LinkedList<Object>();
        while (selectionIterator.hasNext()) {
            Object selectedElement = selectionIterator.next();
            if (!this.supportsCSS(selectedElement)) continue;
            result.add(selectedElement);
        }
        return result;
    }

    private boolean supportsCSS(Object element) {
        View view = this.getView(element);
        return view != null && this.supportsCSS(view);
    }

    private boolean supportsCSS(View view) {
        return view.getDiagram() instanceof CSSDiagram;
    }

    private void debug(List<Object> supportedElements) {
        if (supportedElements.isEmpty()) {
            return;
        }
        this.treeViewer.setInput(supportedElements);
        this.treeViewer.setSelection((ISelection)new StructuredSelection(supportedElements.get(0)));
    }

    private View getView(Object fromElement) {
        View view = null;
        if (fromElement instanceof View) {
            view = (View)fromElement;
        }
        if (fromElement instanceof IAdaptable) {
            view = (View)((IAdaptable)fromElement).getAdapter(View.class);
        }
        return view;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection structuredSelection;
        Object selectedElement;
        View view;
        ISelection selection = event.getSelection();
        if (selection.isEmpty()) {
            this.clean();
            return;
        }
        if (selection instanceof IStructuredSelection && (view = this.getView(selectedElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement())) != null) {
            this.debugView(view);
        }
    }

    private void clean() {
        this.clean(this.viewDescriptionComposite);
        this.clean(this.viewPropertiesComposite);
        this.notationProperties.setInput((Object)"");
        this.semanticProperties.setInput((Object)"");
        this.viewComposite.layout();
        this.viewDescriptionComposite.layout();
    }

    private void clean(Composite composite) {
        Control[] controlArray = composite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    private void debugView(View view) {
        this.clean();
        Diagram diagram = view.getDiagram();
        if (!(diagram instanceof CSSDiagram)) {
            return;
        }
        ExtendedCSSEngine engine = ((CSSDiagram)diagram).getEngine();
        Element cssElement = engine.getElement((Object)view);
        if (!(cssElement instanceof GMFElementAdapter)) {
            return;
        }
        GMFElementAdapter gmfCssElement = (GMFElementAdapter)cssElement;
        this.fillDescription(view, gmfCssElement);
        this.fillProperties(view, gmfCssElement);
        this.fillNotationProperties(view, gmfCssElement);
        this.fillSemanticProperties(view, gmfCssElement);
        this.viewComposite.layout();
    }

    private void fillDescription(View view, GMFElementAdapter cssElement) {
        this.setProperty(this.viewDescriptionComposite, "Name", cssElement.getLocalName());
    }

    private void fillProperties(View view, GMFElementAdapter cssElement) {
        this.setProperty(this.viewPropertiesComposite, "Classes", cssElement.getCSSClass().replaceAll("\\s+", ", "));
        this.setProperty(this.viewPropertiesComposite, "Events", cssElement.getStates().toString());
    }

    private void setProperty(Composite parent, String label, String value) {
        Label labelLabel = new Label(parent, 0);
        labelLabel.setText(label + ": ");
        Label valueLabel = new Label(parent, 0);
        valueLabel.setText(value);
    }

    private void fillNotationProperties(View view, GMFElementAdapter cssElement) {
        List<EStructuralFeature> styleFeatures = this.getStyleFeatures(view);
        this.notationProperties.setInput(styleFeatures);
        this.notationProperties.setLabelProvider((IBaseLabelProvider)new NotationPropertyLabelProvider(cssElement));
    }

    private void fillSemanticProperties(View view, GMFElementAdapter cssElement) {
        EObject semanticElement = cssElement.getSemanticElement();
        if (semanticElement == null) {
            this.semanticProperties.setInput((Object)"");
            return;
        }
        HashSet<EStructuralFeature> semanticFeatures = new HashSet<EStructuralFeature>();
        for (EStructuralFeature semanticFeature : semanticElement.eClass().getEAllStructuralFeatures()) {
            if (!this.isPrimitive(semanticFeature)) continue;
            semanticFeatures.add(semanticFeature);
        }
        this.semanticProperties.setLabelProvider((IBaseLabelProvider)new SemanticPropertyLabelProvider(cssElement));
        this.semanticProperties.setInput(semanticFeatures);
    }

    private boolean isPrimitive(EStructuralFeature feature) {
        HashSet<String> values = new HashSet<String>();
        values.add("boolean");
        values.add("java.lang.Boolean");
        values.add("java.lang.String");
        values.add("int");
        values.add("java.lang.Integer");
        return values.contains(feature.getEType().getInstanceTypeName());
    }

    private List<EStructuralFeature> getStyleFeatures(View view) {
        HashSet allFeatures = new HashSet();
        allFeatures.addAll(view.eClass().getEAllStructuralFeatures());
        LinkedList<EStructuralFeature> styleFeatures = new LinkedList<EStructuralFeature>();
        for (EStructuralFeature feature : allFeatures) {
            if (!EMFHelper.isSubclass((EClass)feature.getEContainingClass(), (EClass)NotationPackage.eINSTANCE.getStyle())) continue;
            styleFeatures.add(feature);
        }
        Collections.sort(styleFeatures, FeatureComparator.instance);
        return styleFeatures;
    }

    protected String getLabel(List<CssTok> expression) {
        if (expression == null || expression.isEmpty()) {
            return "";
        }
        Object label = "";
        for (CssTok token : expression) {
            label = token instanceof SymbolTok ? (String)label + String.valueOf(token) : (String)label + " " + this.getLabel(token);
        }
        return ((String)label).trim().replaceAll("[ ]+", " ");
    }

    protected String getLabel(CssTok term) {
        return (String)new CSSSwitch<String>(){

            public String caseColorTok(ColorTok token) {
                return token.getValue();
            }

            public String caseIdentifierTok(IdentifierTok token) {
                return token.getName();
            }

            public String caseStringTok(StringTok token) {
                return token.getValue();
            }

            public String caseNumberTok(NumberTok token) {
                return Double.toString(token.getVal());
            }

            public String caseIntegerTok(IntegerTok token) {
                return Integer.toString(token.getVal());
            }

            public String caseUrlTok(UrlTok token) {
                Object label = "url('";
                label = (String)label + token.getUrl().getUrl();
                label = (String)label + "')";
                return label;
            }
        }.doSwitch((EObject)term);
    }

    private static class FeatureComparator
    implements Comparator<EStructuralFeature> {
        public static FeatureComparator instance = new FeatureComparator();

        private FeatureComparator() {
        }

        @Override
        public int compare(EStructuralFeature o1, EStructuralFeature o2) {
            return Collator.getInstance().compare(o1.getName(), o2.getName());
        }
    }

    private class NotationPropertyLabelProvider
    extends CellLabelProvider {
        private GMFElementAdapter cssElement;

        public NotationPropertyLabelProvider(GMFElementAdapter cssElement) {
            this.cssElement = cssElement;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof EStructuralFeature)) {
                return;
            }
            EStructuralFeature feature = (EStructuralFeature)element;
            try {
                switch (cell.getColumnIndex()) {
                    case 0: {
                        this.updateProperty(cell, feature);
                        break;
                    }
                    case 1: {
                        this.updatePropertySource(cell, feature);
                        break;
                    }
                    case 2: {
                        this.updateValue(cell, feature);
                    }
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                cell.setText("!! Error !!");
            }
        }

        private void updateProperty(ViewerCell cell, EStructuralFeature feature) {
            cell.setText(feature.getName());
        }

        private void updatePropertySource(ViewerCell cell, EStructuralFeature feature) {
            boolean isSet;
            Object value = this.cssElement.getNotationElement().eGet(feature);
            boolean forced = this.equals(value, feature.getDefaultValue()) ? (isSet = ForceValueHelper.isSet((View)this.cssElement.getNotationElement(), (EStructuralFeature)feature, (Object)value)) : (isSet = this.cssElement.getNotationElement().eIsSet(feature));
            cell.setText(forced ? "Forced value" : "Computed value");
            int systemColor = forced ? 3 : 2;
            cell.setForeground(Display.getDefault().getSystemColor(systemColor));
        }

        private boolean equals(Object value1, Object value2) {
            if (value1 == value2) {
                return true;
            }
            if (value1 == null) {
                return value2.equals(value1);
            }
            return value1.equals(value2);
        }

        private void updateValue(ViewerCell cell, EStructuralFeature feature) {
            Object value = this.cssElement.getNotationElement().eGet(feature);
            String text = this.getValueAsText(feature, value);
            cell.setText(text);
            if (feature.getName().endsWith("Color") && value instanceof Integer) {
                int systemColor;
                Color color = ColorRegistry.getInstance().getColor((Integer)value);
                cell.setBackground(color);
                int lightness = this.getLightness(color);
                systemColor = lightness < 130 ? (systemColor = 1) : 2;
                cell.setForeground(Display.getDefault().getSystemColor(systemColor));
            }
        }

        private int getLightness(Color color) {
            int M = Math.max(color.getGreen(), Math.max(color.getRed(), color.getBlue()));
            int m = Math.min(color.getGreen(), Math.min(color.getRed(), color.getBlue()));
            int L = (M + m) / 2;
            return L;
        }

        private String getValueAsText(EStructuralFeature feature, Object value) {
            if (value instanceof GradientData) {
                GradientData gradient = (GradientData)value;
                return CSSDebugView.this.getLabel(GMFToCSSConverter.instance.convert(gradient));
            }
            if (feature.getName().endsWith("Color") && value instanceof Integer) {
                Color color = FigureUtilities.integerToColor((Integer)((Integer)value));
                String result = CSSDebugView.this.getLabel(GMFToCSSConverter.instance.convert(color));
                color.dispose();
                return result;
            }
            return value == null ? "" : value.toString();
        }
    }

    private class SemanticPropertyLabelProvider
    extends CellLabelProvider {
        private GMFElementAdapter cssElement;

        public SemanticPropertyLabelProvider(GMFElementAdapter cssElement) {
            this.cssElement = cssElement;
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (!(element instanceof EStructuralFeature)) {
                return;
            }
            EStructuralFeature feature = (EStructuralFeature)element;
            try {
                switch (cell.getColumnIndex()) {
                    case 0: {
                        this.updateProperty(cell, feature);
                        break;
                    }
                    case 1: {
                        this.updateValue(cell, feature);
                    }
                }
            }
            catch (Exception ex) {
                Activator.log.error((Throwable)ex);
                cell.setText("!! Error !!");
            }
        }

        private void updateProperty(ViewerCell cell, EStructuralFeature feature) {
            cell.setText(feature.getName());
        }

        private void updateValue(ViewerCell cell, EStructuralFeature feature) {
            Object value = this.cssElement.getSemanticElement().eGet(feature);
            cell.setText(value == null ? "" : value.toString());
        }
    }
}

