/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.toolsmiths.validation.common.internal.utils;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.papyrus.toolsmiths.validation.common.Activator;

public class MarkersManagementUtils {
    public static IMarker createMarker(IResource resource, String type, String message, int severity) {
        IMarker createdMarker = MarkersManagementUtils.createMarker(resource, type);
        if (createdMarker != null) {
            try {
                createdMarker.setAttribute("message", (Object)message);
                createdMarker.setAttribute("severity", severity);
            }
            catch (CoreException e) {
                Activator.log.error("Error while setting marker attributes", (Throwable)e);
            }
        }
        return createdMarker;
    }

    public static IMarker createMarker(IResource resource, String type) {
        IMarker createdMarker = null;
        try {
            createdMarker = resource.createMarker(type);
        }
        catch (CoreException e) {
            Activator.log.error("Error while creating marker", (Throwable)e);
        }
        return createdMarker;
    }

    public static void deleteMarkers(IResource resource, String type) {
        try {
            resource.deleteMarkers(type, true, 2);
        }
        catch (CoreException e) {
            Activator.log.error("Error while deleting markers", (Throwable)e);
        }
    }
}

