/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.utils;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.infra.core.sasheditor.Activator;
import org.eclipse.papyrus.infra.core.sasheditor.api.IPageAddValidator;
import org.osgi.framework.Bundle;

public class PageAddValidatorManager {
    private static String PAGEADDVALIDATOR_EXTENSION_ID = "org.eclipse.papyrus.infra.core.sasheditor.pageAddValidator";
    private static String CLASS_ATTRIBUTE = "class";
    private static PageAddValidatorManager instance;
    private Set<IPageAddValidator> validators = new HashSet<IPageAddValidator>();

    private PageAddValidatorManager() {
        this.initializeValidators();
    }

    public static PageAddValidatorManager getInstance() {
        if (instance == null) {
            instance = new PageAddValidatorManager();
        }
        return instance;
    }

    private void initializeValidators() {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(PAGEADDVALIDATOR_EXTENSION_ID);
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement element = configElements[i];
            Bundle extensionBundle = Platform.getBundle((String)element.getDeclaringExtension().getNamespaceIdentifier());
            String classAttribute = element.getAttribute(CLASS_ATTRIBUTE);
            try {
                Class clazz = extensionBundle.loadClass(classAttribute);
                Object obj = clazz.newInstance();
                this.validators.add((IPageAddValidator)obj);
            }
            catch (Exception e) {
                Activator.log.error("The class '" + classAttribute + "' cannot be accessible from plug-in '" + extensionBundle.getSymbolicName() + "'", (Throwable)e);
            }
            ++i;
        }
    }

    public boolean isValid(Object pageIdentifier) {
        for (IPageAddValidator validator : this.validators) {
            if (validator.isValid(pageIdentifier)) continue;
            return false;
        }
        return true;
    }
}

