/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.textedit.state.xtext.ui.contentassist;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.ui.util.DisplayUtils;
import org.eclipse.papyrus.uml.textedit.state.xtext.ui.contentassist.AbstractUmlStateProposalProvider;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.QualifiedName;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.StateRule;
import org.eclipse.papyrus.uml.textedit.state.xtext.umlState.SubmachineRule;
import org.eclipse.papyrus.uml.xtext.integration.core.ContextElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;

public class UmlStateProposalProvider
extends AbstractUmlStateProposalProvider {
    private ILabelProvider labelProvider = DisplayUtils.getLabelProvider();

    @Override
    public void completeStateRule_Submachine(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ArrayList<StateMachine> allStateMachines = new ArrayList<StateMachine>();
        Namespace namespace = (Namespace)EcoreUtil.getRootContainer((EObject)ContextElementUtil.getContextElement((Resource)model.eResource()));
        allStateMachines.addAll(this.getRecursivelyOwnedStatemachines(namespace));
        allStateMachines.addAll(this.getRecursivelyImportedStatemachines(namespace));
        for (StateMachine s : allStateMachines) {
            if (!s.getName().contains(context.getPrefix())) continue;
            String displayString = s.getQualifiedName();
            String completionString = UmlStateProposalProvider.getSubmachineLabel(s);
            ICompletionProposal completionProposal = this.createCompletionProposalWithReplacementOfPrefix((NamedElement)s, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeSubmachineRule_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Namespace root = (Namespace)EcoreUtil.getRootContainer((EObject)ContextElementUtil.getContextElement((Resource)model.eResource()));
        if (root == null) {
            return;
        }
        String completionString = root.getName() + "::";
        String displayString = root.getName() + "::";
        ICompletionProposal completionProposal = this.createCompletionProposalWithReplacementOfPrefix((NamedElement)root, completionString, displayString, context);
        acceptor.accept(completionProposal);
        EList importedPackages = root.getImportedPackages();
        for (Package p : importedPackages) {
            if (!p.getName().startsWith(context.getPrefix())) continue;
            completionString = p.getName().substring(context.getPrefix().length()) + "::";
            displayString = p.getName() + "::";
            completionProposal = this.createCompletionProposal((NamedElement)root, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeSubmachineRule_Submachine(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        Element contextElement = (Element)ContextElementUtil.getContextElement((Resource)model.eResource());
        Package namespace = contextElement.getNearestPackage();
        if (model instanceof SubmachineRule) {
            SubmachineRule typeRule = (SubmachineRule)model;
            QualifiedName path = typeRule.getPath();
            while (path.getRemaining() != null) {
                path = path.getRemaining();
            }
            namespace = path.getPath();
        } else if (!(model instanceof StateRule)) {
            return;
        }
        for (NamedElement n : namespace.getOwnedMembers()) {
            if (!(n instanceof StateMachine) || !n.getName().startsWith(context.getPrefix())) continue;
            String completionString = n.getName().substring(context.getPrefix().length());
            String displayString = n.getName();
            ICompletionProposal completionProposal = this.createCompletionProposal(n, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    @Override
    public void completeQualifiedName_Path(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
    }

    @Override
    public void completeQualifiedName_Remaining(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        ICompletionProposal completionProposal;
        String displayString;
        String completionString;
        QualifiedName path = (QualifiedName)model;
        for (NamedElement n : path.getPath().getOwnedMembers()) {
            if (!(n instanceof Namespace) || n instanceof StateMachine || !n.getName().startsWith(context.getPrefix())) continue;
            completionString = n.getName().substring(context.getPrefix().length()) + "::";
            displayString = n.getName() + "::";
            completionProposal = this.createCompletionProposal(n, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
        for (Package p : path.getPath().getImportedPackages()) {
            if (!p.getName().startsWith(context.getPrefix())) continue;
            completionString = p.getName().substring(context.getPrefix().length()) + "::";
            displayString = p.getName() + "::";
            completionProposal = this.createCompletionProposal((NamedElement)p, completionString, displayString, context);
            acceptor.accept(completionProposal);
        }
    }

    public static String getSubmachineLabel(StateMachine statemachine) {
        Object label = "";
        Namespace model = (Namespace)EcoreUtil.getRootContainer((EObject)ContextElementUtil.getContextElement((Resource)statemachine.eResource()));
        ArrayList importedPackages = new ArrayList(model.getImportedPackages());
        ArrayList<Namespace> visitedNamespaces = new ArrayList<Namespace>();
        Namespace currentNamespace = statemachine.getNamespace();
        boolean rootFound = false;
        while (currentNamespace != null && !rootFound) {
            Element owner;
            visitedNamespaces.add(currentNamespace);
            if (importedPackages.contains(currentNamespace) || currentNamespace == model) {
                rootFound = true;
            }
            Namespace namespace = currentNamespace = (owner = currentNamespace.getOwner()) != null ? (Namespace)owner : null;
        }
        int i = visitedNamespaces.size() - 1;
        while (i >= 0) {
            label = (String)label + ((Namespace)visitedNamespaces.get(i)).getName() + "::";
            --i;
        }
        return (String)label + statemachine.getName();
    }

    protected ICompletionProposal createCompletionProposal(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n(" + namedElement.eClass().getName() + ")";
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), this.labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo);
        return completionProposal;
    }

    protected ICompletionProposal createCompletionProposalWithReplacementOfPrefix(NamedElement namedElement, String completionString, String displayString, ContentAssistContext context) {
        String additionalProposalInfo = namedElement.getQualifiedName() + "\n(" + namedElement.eClass().getName() + ")";
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset() - context.getPrefix().length(), context.getPrefix().length(), completionString.length(), this.labelProvider.getImage((Object)namedElement), " " + displayString, null, additionalProposalInfo);
        return completionProposal;
    }

    protected ICompletionProposal createCompletionProposal(String completionString, String displayString, ContentAssistContext context) {
        CompletionProposal completionProposal = new CompletionProposal(completionString, context.getOffset(), context.getSelectedText().length(), completionString.length(), null, " " + displayString, null, null);
        return completionProposal;
    }

    private List<StateMachine> getRecursivelyOwnedStatemachines(Namespace context) {
        ArrayList<StateMachine> recursivelyOwnedStatemachines = new ArrayList<StateMachine>();
        EList allOwnedElements = context.getOwnedElements();
        for (Element e : allOwnedElements) {
            if (e instanceof StateMachine) {
                recursivelyOwnedStatemachines.add((StateMachine)e);
                continue;
            }
            if (!(e instanceof Namespace)) continue;
            recursivelyOwnedStatemachines.addAll(this.getRecursivelyOwnedStatemachines((Namespace)e));
        }
        return recursivelyOwnedStatemachines;
    }

    private List<StateMachine> getRecursivelyImportedStatemachines(Namespace context) {
        ArrayList<StateMachine> recursivelyImportedStateMachines = new ArrayList<StateMachine>();
        EList importedPackages = context.getImportedPackages();
        for (Package p : importedPackages) {
            recursivelyImportedStateMachines.addAll(this.getRecursivelyOwnedStatemachines((Namespace)p));
        }
        return recursivelyImportedStateMachines;
    }
}

