/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.AbstractEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractOccurrenceLinkEditHelperAdvice;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLPackage;

public class DurationObservationEditHelperAdvice
extends AbstractOccurrenceLinkEditHelperAdvice {
    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        EObject toConfigure;
        CompositeCommand composite = new CompositeCommand("After Configure Command of DurationObservation");
        ICommand afterConfigureCommand = super.getAfterConfigureCommand(request);
        if (afterConfigureCommand != null && afterConfigureCommand.canExecute()) {
            composite.compose((IUndoableOperation)afterConfigureCommand);
        }
        if (!((toConfigure = request.getElementToConfigure()) instanceof DurationObservation)) {
            return composite;
        }
        final DurationObservation observation = (DurationObservation)toConfigure;
        final NamedElement source = this.getSourceElement((AbstractEditCommandRequest)request);
        final NamedElement target = this.getTargetElement((AbstractEditCommandRequest)request);
        if (source != null && target != null) {
            AbstractTransactionalCommand initConstrainedElements = new AbstractTransactionalCommand(request.getEditingDomain(), "Init DurationObservation events", null){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    observation.getEvents().add(0, (Object)source);
                    if (target != source) {
                        observation.getEvents().add(1, (Object)target);
                    }
                    return CommandResult.newOKCommandResult();
                }
            };
            composite.compose((IUndoableOperation)initConstrainedElements);
        }
        return !composite.isEmpty() ? composite : null;
    }

    protected ICommand getAfterReorientRelationshipCommand(ReorientRelationshipRequest request) {
        EObject relationship = request.getRelationship();
        if (relationship instanceof DurationObservation) {
            DurationObservation observation = (DurationObservation)relationship;
            EObject newEnd = request.getNewRelationshipEnd();
            if (newEnd instanceof OccurrenceSpecification) {
                OccurrenceSpecification newOccurrence = (OccurrenceSpecification)newEnd;
                ArrayList<OccurrenceSpecification> values = new ArrayList<OccurrenceSpecification>((Collection<OccurrenceSpecification>)observation.getEvents());
                if (request.getDirection() == 1) {
                    if (values.isEmpty()) {
                        values.add(newOccurrence);
                    } else if (values.size() == 1) {
                        values.add(0, newOccurrence);
                    } else {
                        if (values.get(0) == newOccurrence) {
                            return null;
                        }
                        values.set(0, newOccurrence);
                    }
                } else if (values.isEmpty()) {
                    values.add(newOccurrence);
                } else if (values.size() == 1) {
                    values.add(newOccurrence);
                } else {
                    if (values.get(1) == newOccurrence) {
                        return null;
                    }
                    values.set(1, newOccurrence);
                }
                SetRequest setRequest = new SetRequest((EObject)observation, (EStructuralFeature)UMLPackage.Literals.DURATION_OBSERVATION__EVENT, values);
                return new SetValueCommand(setRequest);
            }
        }
        return super.getAfterReorientRelationshipCommand(request);
    }

    protected NamedElement getSourceElement(AbstractEditCommandRequest request) {
        Element source = super.getSourceElement(request);
        return source instanceof NamedElement ? (NamedElement)source : null;
    }

    protected NamedElement getTargetElement(AbstractEditCommandRequest request) {
        Element target = super.getTargetElement(request);
        return target instanceof NamedElement ? (NamedElement)target : null;
    }

    @Override
    protected Element getCreationContainer(Element targetElement) {
        return targetElement.getNearestPackage();
    }
}

