/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.helper;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.ContentHandler;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.emf.resource.AnyRootNamespaceContentHandler;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.decoratormodel.Activator;
import org.eclipse.papyrus.uml.decoratormodel.helper.IDeleteEmptyDecoratorModelsPolicy;
import org.eclipse.papyrus.uml.decoratormodel.helper.PapyrusProfileApplicationHelper;
import org.eclipse.papyrus.uml.decoratormodel.helper.PapyrusStereotypeApplicationHelper;
import org.eclipse.papyrus.uml.decoratormodel.internal.commands.CreateDecoratorModelCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.commands.DeleteDecoratorModelCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.commands.ReclaimProfileApplicationsCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.commands.SaveDecoratorModelCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.commands.SeparateProfileApplicationsCommand;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.model.DecoratorModel;
import org.eclipse.papyrus.uml.decoratormodel.profileExternalization.ApplyProfiles;
import org.eclipse.papyrus.uml.decoratormodel.profileExternalization.ProfileExternalizationPackage;
import org.eclipse.papyrus.uml.tools.utils.CustomUMLUtil;
import org.eclipse.uml2.common.util.CacheAdapter;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DecoratorModelUtils {
    public static final URI PROFILE_URI = URI.createURI((String)"pathmap://PAPYRUS_PROFILEEXT/ProfileExternalization.profile.uml#_Mzzc0EWjEeSNXJj2G3jVCw", (boolean)true);
    public static final IContentType DECORATOR_MODEL_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.papyrus.uml.decoratormodel.decorator_model");
    private static final ContentHandler DECORATOR_MODEL_CONTENT_HANDLER = new AnyRootNamespaceContentHandler(DECORATOR_MODEL_CONTENT_TYPE.getId(), null, "http://www.eclipse.org/Papyrus/2014/profile/profileExternalization");
    private static final String STEREOTYPE_PREFIX = "ProfileExternalization::";
    public static final String APPLY_PROFILES_QNAME = "ProfileExternalization::ApplyProfiles";
    private static final Object LOADED_RESOURCES_CACHE_KEY = new Object();
    private static final Object UNLOADED_RESOURCE_DECORATORS_CACHE_KEY = new Object();
    private static final Object UNLOADED_PACKAGE_DECORATORS_CACHE_KEY = new Object();
    private static final Object INTRINSIC_PROFILE_APPLICATIONS_CACHE_KEY = new Object();

    public static void externalizeProfileApplication(ProfileApplication profileApplication, Resource decoratorResource) {
        Resource sourceResource = profileApplication.eResource();
        ResourceSet resourceSet = sourceResource == null ? null : sourceResource.getResourceSet();
        Package applyingPackage = profileApplication.getApplyingPackage();
        Profile appliedProfile = profileApplication.getAppliedProfile();
        Package decoratorModel = DecoratorModelUtils.getDecoratorModel(decoratorResource);
        Package externalPackage = DecoratorModelUtils.getDecoratorPackage(decoratorModel, profileApplication.getApplyingPackage(), true);
        externalPackage.getProfileApplications().add((Object)profileApplication);
        ArrayList<EObject> stereotypeApplications = new ArrayList<EObject>();
        TreeIterator iter = UML2Util.getAllContents((EObject)applyingPackage, (boolean)true, (boolean)false);
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (next instanceof Package && ((Package)next).getProfileApplication(appliedProfile) != null) {
                iter.prune();
                continue;
            }
            if (next instanceof Element) {
                for (EObject stereotypeAppl : ((Element)next).getStereotypeApplications()) {
                    if (!DecoratorModelUtils.isDefinedBy(profileApplication, stereotypeAppl)) continue;
                    stereotypeApplications.add(stereotypeAppl);
                }
                continue;
            }
            iter.prune();
        }
        UMLUtil.StereotypeApplicationHelper stereotypeHelper = UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)resourceSet);
        for (EObject next : stereotypeApplications) {
            stereotypeHelper.addToContainmentList(UMLUtil.getBaseElement((EObject)next), next);
        }
    }

    public static void internalizeProfileApplications(Iterable<? extends ProfileApplication> profileApplications, IDeleteEmptyDecoratorModelsPolicy deletePolicy) {
        ArrayList emptyDecoratorModels = Lists.newArrayList();
        for (ProfileApplication profileApplication : profileApplications) {
            Resource sourceResource = profileApplication.eResource();
            if (sourceResource == null) continue;
            ResourceSet resourceSet = sourceResource.getResourceSet();
            Package externalPackage = profileApplication.getApplyingPackage();
            Package applyingPackage = DecoratorModelUtils.getUserPackage(externalPackage);
            ArrayList<EObject> stereotypeApplications = new ArrayList<EObject>();
            for (EObject next : sourceResource.getContents()) {
                if (next instanceof Element || !DecoratorModelUtils.isDefinedBy(profileApplication, next)) continue;
                stereotypeApplications.add(next);
            }
            applyingPackage.getProfileApplications().add((Object)profileApplication);
            Package root = externalPackage.getNestingPackage();
            EList remaining = externalPackage.getProfileApplications();
            if (remaining.isEmpty()) {
                externalPackage.destroy();
                if (root != null && root.getNestedPackages().isEmpty()) {
                    emptyDecoratorModels.add(root);
                }
            }
            UMLUtil.StereotypeApplicationHelper stereotypeHelper = UMLUtil.StereotypeApplicationHelper.getInstance((Notifier)resourceSet);
            for (EObject next : stereotypeApplications) {
                stereotypeHelper.addToContainmentList(UMLUtil.getBaseElement((EObject)next), next);
            }
        }
        if (!emptyDecoratorModels.isEmpty() && DecoratorModelUtils.shouldDelete(emptyDecoratorModels, deletePolicy)) {
            CustomUMLUtil.destroyAll((Collection)emptyDecoratorModels);
        }
    }

    private static boolean shouldDelete(Collection<? extends Package> decoratorModels, IDeleteEmptyDecoratorModelsPolicy deletePolicy) {
        boolean result;
        boolean bl = result = deletePolicy == null;
        if (!result) {
            LinkedHashSet decoratorModelResources = Sets.newLinkedHashSet();
            for (Package package_ : decoratorModels) {
                decoratorModelResources.add(package_.eResource());
            }
            result = deletePolicy.shouldDeleteDecoratorModels(decoratorModelResources);
        }
        return result;
    }

    public static Profile getExternalizationProfile(ResourceSet resourceSet) {
        return (Profile)resourceSet.getEObject(PROFILE_URI, true);
    }

    public static Package getDecoratorModel(Resource resource) {
        Package result = null;
        Profile externalizationProfile = DecoratorModelUtils.getExternalizationProfile(resource.getResourceSet());
        for (Package next : Iterables.filter((Iterable)resource.getContents(), Package.class)) {
            if (!next.isProfileApplied(externalizationProfile)) continue;
            result = next;
            break;
        }
        return result;
    }

    private static boolean isDefinedBy(ProfileApplication profileApplication, EObject stereotypeApplication) {
        Stereotype stereotype;
        boolean result = false;
        Element baseElement = UMLUtil.getBaseElement((EObject)stereotypeApplication);
        if (baseElement != null && (stereotype = UMLUtil.getStereotype((EObject)stereotypeApplication)) != null) {
            result = profileApplication.getAppliedDefinition((NamedElement)stereotype) == stereotypeApplication.eClass();
        }
        return result;
    }

    private static boolean isApplyProfiles(Dependency dependency) {
        boolean result = false;
        CacheAdapter cache = CacheAdapter.getInstance();
        if (cache != null) {
            for (EStructuralFeature.Setting setting : cache.getNonNavigableInverseReferences((EObject)dependency)) {
                if (setting.getEStructuralFeature() != ProfileExternalizationPackage.Literals.APPLY_PROFILES__BASE_DEPENDENCY) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public static Iterable<Package> getDecoratorPackages(Package package_) {
        LinkedHashSet<Package> result = null;
        for (ApplyProfiles next : DecoratorModelUtils.getDecoratorModelDependencies(package_)) {
            if (result == null) {
                result = new LinkedHashSet<Package>();
            }
            result.addAll((Collection<Package>)next.getExternalizedAppliedProfilePackages());
        }
        return result == null ? Collections.emptySet() : result;
    }

    public static Iterable<ProfileApplication> getDecoratorModelProfileApplications(Package package_) {
        LinkedHashSet result = null;
        for (ApplyProfiles next : DecoratorModelUtils.getDecoratorModelDependencies(package_)) {
            if (result == null) {
                result = new LinkedHashSet();
            }
            for (Package externalPackage : next.getExternalizedAppliedProfilePackages()) {
                result.addAll(externalPackage.getProfileApplications());
            }
        }
        return result == null ? Collections.emptySet() : result;
    }

    public static Package getUserModelApplyingPackage(ProfileApplication profileApplication) {
        Package applying = profileApplication.getApplyingPackage();
        Package userPackage = DecoratorModelUtils.getUserPackage(applying);
        return userPackage == null ? applying : userPackage;
    }

    public static Map<Package, Profile> getDecoratorProfileApplications(Resource decoratorModel) {
        HashMap result = Maps.newHashMap();
        for (ApplyProfiles next : Iterables.filter((Iterable)decoratorModel.getContents(), ApplyProfiles.class)) {
            Dependency base = next.getBase_Dependency();
            if (base == null) continue;
            for (Package applying : Iterables.filter((Iterable)base.getClients(), Package.class)) {
                for (Profile profile : next.getAppliedProfiles()) {
                    result.put(applying, profile);
                }
            }
        }
        return result;
    }

    public static Iterable<Profile> getDecoratorModelAppliedProfiles(Package package_) {
        LinkedHashSet<Profile> result = null;
        for (ApplyProfiles next : DecoratorModelUtils.getDecoratorModelDependencies(package_)) {
            if (result == null) {
                result = new LinkedHashSet<Profile>();
            }
            result.addAll((Collection<Profile>)next.getAppliedProfiles());
        }
        return result == null ? Collections.emptySet() : result;
    }

    public static Map<URI, Map<URI, URI>> getAllDecoratorModelAppliedProfileDefinitions(Package package_) throws CoreException {
        return DecoratorModelUtils.getAllDecoratorModelAppliedProfileDefinitions(package_, true, true);
    }

    public static Map<URI, Map<URI, URI>> getAllDecoratorModelAppliedProfileDefinitions(Package package_, boolean includeLoaded, boolean includeUnloaded) throws CoreException {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Package each : Iterables.concat(Collections.singleton(package_), (Iterable)package_.allOwningPackages())) {
            ResourceSet rset;
            Map<URI, Map<URI, URI>> index;
            Iterable<ProfileApplication> loaded;
            if (includeLoaded && !Iterables.isEmpty(loaded = DecoratorModelUtils.getDecoratorModelProfileApplications(each))) {
                for (ProfileApplication next : loaded) {
                    Profile profile = next.getAppliedProfile();
                    EPackage definition = next.getAppliedDefinition();
                    if (profile == null || definition == null) continue;
                    URI profileURI = EcoreUtil.getURI((EObject)profile);
                    URI decoratorURI = next.eResource().getURI();
                    URI definitionURI = EcoreUtil.getURI((EObject)definition);
                    Map definitions = (Map)result.get(profileURI);
                    if (definitions == null) {
                        definitions = Maps.newHashMap();
                        result.put(profileURI, definitions);
                    }
                    if (definitions.containsKey(decoratorURI)) continue;
                    definitions.put(decoratorURI, definitionURI);
                }
            }
            if (!includeUnloaded || (index = DecoratorModelIndex.getInstance().getAllAppliedProfileDefinitions(EcoreUtil.getURI((EObject)each))).isEmpty() || (rset = EMFHelper.getResourceSet((EObject)each)) == null) continue;
            for (URI profile : index.keySet()) {
                Map profileResult = (Map)result.get(profile);
                if (profileResult == null) {
                    profileResult = Maps.newHashMap();
                    result.put(profile, profileResult);
                }
                for (Map.Entry<URI, URI> application : index.get(profile).entrySet()) {
                    Resource resource;
                    URI decorator = application.getKey();
                    if (profileResult.containsKey(decorator) || (resource = rset.getResource(decorator, false)) != null && resource.isLoaded()) continue;
                    profileResult.put(decorator, application.getValue());
                }
            }
        }
        return result;
    }

    static Iterable<ApplyProfiles> getDecoratorModelDependencies(Package package_) {
        ArrayList<ApplyProfiles> result = null;
        for (Dependency dependency : package_.getClientDependencies()) {
            for (EStructuralFeature.Setting setting : CacheAdapter.getInstance().getNonNavigableInverseReferences((EObject)dependency)) {
                if (setting.getEStructuralFeature() != ProfileExternalizationPackage.Literals.APPLY_PROFILES__BASE_DEPENDENCY) continue;
                if (result == null) {
                    result = new ArrayList<ApplyProfiles>();
                }
                result.add((ApplyProfiles)setting.getEObject());
            }
        }
        return result == null ? Collections.emptyList() : result;
    }

    public static Package getDecoratorPackage(Package externalizationModel, Package userPackage, boolean createIfNecessary) {
        Package result = null;
        for (Package next : externalizationModel.getNestedPackages()) {
            if (DecoratorModelUtils.getUserPackage(next) != userPackage) continue;
            result = next;
            break;
        }
        if (result == null) {
            result = externalizationModel.createNestedPackage(UML2Util.getValidJavaIdentifier((String)userPackage.getQualifiedName()));
            Dependency dependency = UMLFactory.eINSTANCE.createDependency();
            dependency.getClients().add((Object)userPackage);
            dependency.getSuppliers().add((Object)result);
            result.getPackagedElements().add((Object)dependency);
            dependency.applyStereotype(dependency.getApplicableStereotype(APPLY_PROFILES_QNAME));
        }
        return result;
    }

    public static Package getUserPackage(Package decoratorPackage) {
        Package result = null;
        for (Dependency next : Iterables.filter((Iterable)decoratorPackage.getTargetDirectedRelationships(UMLPackage.Literals.DEPENDENCY), Dependency.class)) {
            if (DecoratorModelUtils.isApplyProfiles(next) && (result = (Package)Iterables.getFirst((Iterable)Iterables.filter((Iterable)next.getClients(), Package.class), null)) != null) break;
        }
        return result;
    }

    public static boolean hasExternalizationProfile(Package package_) {
        boolean result = false;
        for (Profile next : package_.getAppliedProfiles()) {
            if (!PROFILE_URI.equals(EcoreUtil.getURI((EObject)next))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Command createSeparateProfileApplicationsCommand(Iterable<? extends ProfileApplication> profileApplications, URI resourceURI, String modelName) {
        Object result;
        ProfileApplication any = (ProfileApplication)Iterables.getFirst(profileApplications, null);
        if (any == null) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)any);
            if (domain == null) {
                result = UnexecutableCommand.INSTANCE;
            } else {
                result = new CreateDecoratorModelCommand(domain, resourceURI, modelName);
                CompoundCommand compound = new CompoundCommand(1, result.getLabel(), result.getDescription());
                compound.append((Command)result);
                result = compound;
                compound.append((Command)new SeparateProfileApplicationsCommand(domain, profileApplications, resourceURI));
                if (domain.getResourceSet() instanceof ModelSet) {
                    compound.append((Command)new SaveDecoratorModelCommand((ModelSet)domain.getResourceSet(), resourceURI));
                }
            }
        }
        return result;
    }

    public static Command createReclaimProfileApplicationsCommand(Iterable<? extends ProfileApplication> profileApplications) {
        return DecoratorModelUtils.createReclaimProfileApplicationsCommand(profileApplications, null);
    }

    public static Command createReclaimProfileApplicationsCommand(Iterable<? extends ProfileApplication> profileApplications, IDeleteEmptyDecoratorModelsPolicy deletePolicy) {
        Object result;
        ProfileApplication any = (ProfileApplication)Iterables.getFirst(profileApplications, null);
        if (any == null) {
            result = UnexecutableCommand.INSTANCE;
        } else {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)any);
            if (domain == null) {
                result = UnexecutableCommand.INSTANCE;
            } else {
                result = new ReclaimProfileApplicationsCommand(domain, profileApplications, deletePolicy);
                CompoundCommand compound = new CompoundCommand(0, result.getLabel(), result.getDescription());
                compound.append((Command)result);
                result = compound;
                if (domain.getResourceSet() instanceof ModelSet) {
                    ModelSet modelSet = (ModelSet)domain.getResourceSet();
                    HashSet resourcesToDelete = Sets.newHashSet();
                    for (ProfileApplication profileApplication : profileApplications) {
                        Resource toDelete = profileApplication.eResource();
                        if (!resourcesToDelete.add(toDelete.getURI())) continue;
                        compound.append((Command)new DeleteDecoratorModelCommand(modelSet, toDelete));
                    }
                }
            }
        }
        return result;
    }

    public static boolean isDecoratorModel(Package package_) {
        return ((InternalEObject)package_).eDirectResource() != null && DecoratorModelUtils.hasExternalizationProfile(package_);
    }

    public static boolean isDecoratorModel(Resource resource) {
        boolean result = false;
        Package root = (Package)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resource.getContents(), Package.class), null);
        if (root != null) {
            result = DecoratorModelUtils.isDecoratorModel(root);
        }
        return result;
    }

    public static boolean isDecoratorModelFor(Resource resource, Resource modelResource) {
        boolean result = false;
        ResourceSet rset = resource.getResourceSet();
        if (rset != null) {
            for (ApplyProfiles next : Iterables.filter((Iterable)EcoreUtil.getObjectsByType((Collection)resource.getContents(), (EClassifier)ProfileExternalizationPackage.Literals.APPLY_PROFILES), ApplyProfiles.class)) {
                Dependency baseDependency = next.getBase_Dependency();
                if (baseDependency == null) continue;
                Iterator iter = ((InternalEList)baseDependency.getClients()).basicIterator();
                while (!result && iter.hasNext()) {
                    NamedElement client = (NamedElement)iter.next();
                    if (client.eIsProxy()) {
                        URI uri = EcoreUtil.getURI((EObject)client).trimFragment();
                        result = uri.equals(modelResource.getURI());
                        continue;
                    }
                    boolean bl = result = client.eResource() == modelResource;
                }
            }
        }
        return result;
    }

    public static Set<URI> getUserModelResources(Resource decoratorModelResource) {
        HashSet result = Sets.newHashSet();
        for (ApplyProfiles next : Iterables.filter((Iterable)EcoreUtil.getObjectsByType((Collection)decoratorModelResource.getContents(), (EClassifier)ProfileExternalizationPackage.Literals.APPLY_PROFILES), ApplyProfiles.class)) {
            Dependency baseDependency = next.getBase_Dependency();
            if (baseDependency == null) continue;
            Iterator iter = ((InternalEList)baseDependency.getClients()).basicIterator();
            while (iter.hasNext()) {
                NamedElement client = (NamedElement)iter.next();
                if (client.eIsProxy()) {
                    result.add(EcoreUtil.getURI((EObject)client).trimFragment());
                    continue;
                }
                result.add(client.eResource().getURI());
            }
        }
        result.remove(decoratorModelResource.getURI());
        return result;
    }

    public static boolean isDecoratorModel(IFile file) {
        boolean result = false;
        if (file.isAccessible()) {
            try {
                IContentDescription desc = file.exists() ? file.getContentDescription() : null;
                result = desc != null && desc.getContentType() != null && desc.getContentType().isKindOf(DECORATOR_MODEL_CONTENT_TYPE);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
        }
        return result;
    }

    public static boolean isDecoratorModel(URI uri) {
        boolean result;
        block15: {
            result = false;
            if (uri.isPlatformResource()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                result = DecoratorModelUtils.isDecoratorModel(file);
            } else {
                InputStream input = null;
                try {
                    try {
                        input = URIConverter.INSTANCE.createInputStream(uri);
                        if (!input.markSupported()) {
                            input = new BufferedInputStream(input);
                        }
                        input.mark(Integer.MAX_VALUE);
                        Map desc = DECORATOR_MODEL_CONTENT_HANDLER.contentDescription(uri, input, (Map)Maps.newHashMap(), (Map)Maps.newHashMap());
                        result = desc.get("org.eclipse.emf.ecore:validity") == ContentHandler.Validity.VALID;
                    }
                    catch (Exception exception) {
                        if (input == null) break block15;
                        try {
                            input.close();
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
                finally {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception e) {
                            Activator.log.error((Throwable)e);
                        }
                    }
                }
            }
        }
        return result;
    }

    public static Set<URI> getLoadedDecoratorModels(Resource modelResource) {
        Element root = (Element)EcoreUtil.getObjectByType((Collection)modelResource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
        if (root == null) {
            return Collections.emptySet();
        }
        CacheAdapter cache = CacheAdapter.getInstance();
        Set result = (Set)cache.get((EObject)root, LOADED_RESOURCES_CACHE_KEY);
        if (result == null) {
            result = Sets.newHashSet();
            DecoratorModelUtils.collectLoadedDecoratorModels(modelResource, result);
            cache.put((EObject)root, LOADED_RESOURCES_CACHE_KEY, (Object)result);
        }
        return result;
    }

    private static void collectLoadedDecoratorModels(Resource modelResource, Set<URI> result) {
        if (!DecoratorModelUtils.isDecoratorModel(modelResource)) {
            ResourceSet resourceSet = modelResource.getResourceSet();
            URI modelURI = modelResource.getURI();
            for (Resource next : resourceSet.getResources()) {
                URI uri = next.getURI();
                if (!next.isLoaded() || uri.equals(modelURI) || !DecoratorModelUtils.isDecoratorModelFor(next, modelResource)) continue;
                result.add(uri);
            }
        }
    }

    public static Set<URI> getUnloadedDecoratorModels(Resource modelResource) {
        Element root = (Element)EcoreUtil.getObjectByType((Collection)modelResource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
        if (root == null) {
            return Collections.emptySet();
        }
        CacheAdapter cache = CacheAdapter.getInstance();
        Set result = (Set)cache.get((EObject)root, UNLOADED_RESOURCE_DECORATORS_CACHE_KEY);
        if (result == null) {
            result = Sets.newHashSet();
            try {
                DecoratorModelUtils.collectUnloadedDecoratorModels(DecoratorModelIndex.getInstance().getDecoratorModels(), modelResource, result);
            }
            catch (CoreException e) {
                Activator.log.error("Error in determining unloaded decorator models.", (Throwable)e);
            }
            cache.put((EObject)root, UNLOADED_RESOURCE_DECORATORS_CACHE_KEY, (Object)result);
        }
        return result;
    }

    public static ListenableFuture<Set<URI>> getUnloadedDecoratorModelsAsync(Resource modelResource) {
        return DecoratorModelUtils.getUnloadedDecoratorModelsAsync(Collections.singleton(modelResource));
    }

    public static ListenableFuture<Set<URI>> getUnloadedDecoratorModelsAsync(final Iterable<Resource> modelResources) {
        if (Iterables.isEmpty(modelResources)) {
            return Futures.immediateFuture(Collections.emptySet());
        }
        ListenableFuture<SetMultimap<URI, URI>> decoratorMap = DecoratorModelIndex.getInstance().getDecoratorModelsAsync();
        Function<SetMultimap<URI, URI>, Set<URI>> transform = new Function<SetMultimap<URI, URI>, Set<URI>>(){

            public Set<URI> apply(SetMultimap<URI, URI> input) {
                HashSet result = Sets.newHashSet();
                for (Resource modelResource : modelResources) {
                    Element root;
                    Element element = root = Iterables.isEmpty((Iterable)modelResources) ? null : (Element)EcoreUtil.getObjectByType((Collection)modelResource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
                    if (root == null) continue;
                    CacheAdapter cache = CacheAdapter.getInstance();
                    Set local = (Set)cache.get((EObject)root, UNLOADED_RESOURCE_DECORATORS_CACHE_KEY);
                    if (local == null) {
                        local = Sets.newHashSet();
                        DecoratorModelUtils.collectUnloadedDecoratorModels(input, modelResource, local);
                        cache.put((EObject)root, UNLOADED_RESOURCE_DECORATORS_CACHE_KEY, (Object)local);
                    }
                    result.addAll(local);
                }
                return result;
            }
        };
        return Futures.transform(decoratorMap, (Function)transform, (Executor)MoreExecutors.directExecutor());
    }

    public static ListenableFuture<Set<URI>> getUnloadedDecoratorModelsAsync(final Package package_) {
        if (package_.eResource() == null) {
            return Futures.immediateFuture(Collections.emptySet());
        }
        CacheAdapter cache = CacheAdapter.getInstance();
        Set cached = (Set)cache.get((EObject)package_, UNLOADED_PACKAGE_DECORATORS_CACHE_KEY);
        if (cached != null) {
            return Futures.immediateFuture((Object)cached);
        }
        ListenableFuture<Set<URI>> decoratorMap = DecoratorModelIndex.getInstance().getDecoratorModelsForPackageAsync(EcoreUtil.getURI((EObject)package_));
        Function<Set<URI>, Set<URI>> transform = new Function<Set<URI>, Set<URI>>(){

            public Set<URI> apply(Set<URI> input) {
                HashSet result = Sets.newHashSet();
                Resource resource = package_.eResource();
                if (resource != null) {
                    try {
                        DecoratorModelUtils.collectUnloadedDecoratorModels(DecoratorModelIndex.getInstance().getDecoratorModels(), resource, result);
                    }
                    catch (CoreException e) {
                        throw new UncheckedExecutionException((Throwable)e);
                    }
                }
                result.retainAll(input);
                CacheAdapter cache = CacheAdapter.getInstance();
                cache.put((EObject)package_, UNLOADED_PACKAGE_DECORATORS_CACHE_KEY, (Object)result);
                return result;
            }
        };
        return Futures.transform(decoratorMap, (Function)transform, (Executor)MoreExecutors.directExecutor());
    }

    public static ListenableFuture<Boolean> hasUnloadedDecoratorModelsAsync(Package package_, boolean recursive) {
        Resource modelResource = package_.eResource();
        if (modelResource == null || DecoratorModelUtils.isDecoratorModel(modelResource)) {
            return Futures.immediateFuture((Object)Boolean.FALSE);
        }
        Iterable<Object> resources = Collections.singleton(modelResource);
        if (recursive) {
            resources = Iterables.concat(resources, DecoratorModelUtils.getLoadedSubUnitPackageResources(package_));
        }
        return Futures.transform(DecoratorModelUtils.getUnloadedDecoratorModelsAsync(resources), (Function)new Function<Collection<?>, Boolean>(){

            public Boolean apply(Collection<?> input) {
                if (input != null && !input.isEmpty()) {
                    return true;
                }
                return false;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    private static void collectUnloadedDecoratorModels(SetMultimap<URI, URI> userModelsToDecoratorModels, Resource modelResource, Set<URI> result) {
        URI uri = modelResource.getURI();
        ResourceSet resourceSet = modelResource.getResourceSet();
        if (uri.isPlatformResource() && !DecoratorModelUtils.isDecoratorModel(modelResource)) {
            Set pendingDeletion = resourceSet instanceof ModelSet ? ((ModelSet)resourceSet).getResourcesToDeleteOnSave() : Collections.emptySet();
            try {
                for (URI indexed : Sets.difference((Set)userModelsToDecoratorModels.get((Object)uri), (Set)pendingDeletion)) {
                    Resource indexedResource = resourceSet.getResource(indexed, false);
                    if (indexedResource != null && indexedResource.isLoaded() || DecoratorModelUtils.hasConflictingProfileApplication(indexed, modelResource)) continue;
                    result.add(indexed);
                }
            }
            catch (CoreException e) {
                Activator.log.error("Error in determining unloaded decorator models.", (Throwable)e);
            }
        }
    }

    private static Collection<ProfileApplication> getIntrinsicProfileApplications(Resource modelResource) {
        Element root = (Element)EcoreUtil.getObjectByType((Collection)modelResource.getContents(), (EClassifier)UMLPackage.Literals.ELEMENT);
        if (root == null) {
            return Collections.emptyList();
        }
        CacheAdapter cache = CacheAdapter.getInstance();
        Collection result = (Collection)cache.get((EObject)root, INTRINSIC_PROFILE_APPLICATIONS_CACHE_KEY);
        if (result == null) {
            result = Lists.newArrayList();
            TreeIterator iter = EcoreUtil.getAllProperContents((EObject)root, (boolean)false);
            while (iter.hasNext()) {
                EObject next = (EObject)iter.next();
                if (next instanceof ProfileApplication) {
                    result.add((ProfileApplication)next);
                    iter.prune();
                    continue;
                }
                if (next instanceof Package || next instanceof Component) continue;
                iter.prune();
            }
            cache.put((EObject)root, INTRINSIC_PROFILE_APPLICATIONS_CACHE_KEY, (Object)result);
        }
        return result;
    }

    private static boolean hasConflictingProfileApplication(URI profileApplicationResourceURI, Resource modelResource) throws CoreException {
        boolean result = false;
        SetMultimap<URI, URI> indexed = DecoratorModelIndex.getInstance().getAppliedProfilesByPackage(profileApplicationResourceURI);
        for (ProfileApplication profileApplication : DecoratorModelUtils.getIntrinsicProfileApplications(modelResource)) {
            if (!indexed.containsEntry((Object)EcoreUtil.getURI((EObject)profileApplication.getApplyingPackage()), (Object)EcoreUtil.getURI((EObject)profileApplication.getAppliedProfile()))) continue;
            result = true;
            break;
        }
        return result;
    }

    public static Iterable<Package> getLoadedSubUnitPackages(Package package_) {
        ArrayList result = Lists.newArrayListWithExpectedSize((int)0);
        Resource topResource = package_.eResource();
        TreeIterator iter = EcoreUtil.getAllContents((EObject)package_, (boolean)false);
        while (iter.hasNext()) {
            EObject next = (EObject)iter.next();
            if (next instanceof Package) {
                if (next.eIsProxy() || next.eResource() == topResource) continue;
                result.add((Package)next);
                continue;
            }
            if (next instanceof Component) continue;
            iter.prune();
        }
        return result;
    }

    static Iterable<Resource> getLoadedSubUnitPackageResources(Package package_) {
        return Iterables.transform(DecoratorModelUtils.getLoadedSubUnitPackages(package_), DecoratorModelUtils.getResourceFunction());
    }

    static Function<EObject, Resource> getResourceFunction() {
        return new Function<EObject, Resource>(){

            public Resource apply(EObject input) {
                return input.eResource();
            }
        };
    }

    public static boolean loadDecoratorModels(final ResourceSet resourceSet, final Iterable<? extends URI> resourceURIs) {
        boolean result = false;
        Runnable operation = new Runnable(){

            @Override
            public void run() {
                if (resourceSet instanceof ModelSet) {
                    DecoratorModel model = DecoratorModel.getInstance((ModelSet)resourceSet);
                    for (URI next : resourceURIs) {
                        model.loadDecoratorModel(next);
                    }
                } else {
                    for (URI next : resourceURIs) {
                        resourceSet.getResource(next, true);
                    }
                }
            }
        };
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((ResourceSet)resourceSet);
        if (domain != null) {
            try {
                domain.runExclusive(operation);
                result = true;
            }
            catch (InterruptedException e) {
                Activator.log.error((Throwable)e);
            }
        } else {
            operation.run();
        }
        return result;
    }

    public static void configure(ResourceSet resourceSet) {
        if (resourceSet == null) {
            throw new IllegalArgumentException("null resourceSet");
        }
        UMLUtil.ProfileApplicationHelper.setInstance((ResourceSet)resourceSet, (UMLUtil.ProfileApplicationHelper)new PapyrusProfileApplicationHelper());
        UMLUtil.StereotypeApplicationHelper.setInstance((ResourceSet)resourceSet, (UMLUtil.StereotypeApplicationHelper)new PapyrusStereotypeApplicationHelper());
    }
}

