/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.validation;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.pivot.internal.resource.OCLAdapter;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.xtext.completeocl.utilities.CompleteOCLLoader;
import org.eclipse.papyrus.infra.services.validation.IValidationHook;
import org.eclipse.papyrus.uml.service.validation.Activator;

public abstract class AbstractOCLRegistration
implements IValidationHook {
    protected abstract URI getOCLFileURI();

    protected abstract boolean isApplicable(EObject var1);

    public void beforeValidation(EObject element) {
        if (this.isApplicable(element)) {
            this.addOCLResource(element);
        }
    }

    public void afterValidation(EObject element) {
    }

    public void addOCLResource(EObject element) {
        if (element == null || element.eResource() == null || element.eResource().getResourceSet() == null) {
            return;
        }
        URI oclURI = this.getOCLFileURI();
        ResourceSet modelResources = element.eResource().getResourceSet();
        for (Resource resource : modelResources.getResources()) {
            if (!resource.getURI().equals(oclURI)) continue;
            return;
        }
        OCLAdapter oclAdapter = OCLAdapter.getAdapter((ResourceSet)modelResources);
        CompleteOCLLoader helper = new CompleteOCLLoader((EnvironmentFactory)oclAdapter.getEnvironmentFactory()){

            protected boolean error(String primaryMessage, String detailMessage) {
                Activator.debug("Can not get environment factory");
                return false;
            }
        };
        helper.loadMetamodels();
        try {
            if (!helper.loadDocument(oclURI)) {
                Activator.debug("Can not load OCL document with URI: " + oclURI.path());
            }
        }
        catch (Throwable e) {
            Activator.debug(String.format("Exception %s during loading of OCL document with URI: %s", e.getMessage(), oclURI.path()));
        }
        helper.installPackages();
    }
}

