/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.parsers;

import java.io.Reader;
import org.eclipse.papyrus.infra.nattable.parsers.CSVLexer;
import org.eclipse.papyrus.infra.nattable.parsers.CellIterator;
import org.eclipse.papyrus.infra.nattable.parsers.RowIterator;

public class CSVParser {
    private CSVLexer lexer;
    private RowIterator output;

    public CSVParser(Reader input, char valueSeparator, char textMarker) {
        this(input, valueSeparator, textMarker, false);
    }

    public CSVParser(Reader input, char valueSeparator, char textMarker, boolean keepBeginningWhiteSpace) {
        this.lexer = new CSVLexer(input, valueSeparator, textMarker, keepBeginningWhiteSpace);
        this.output = new Document();
    }

    public RowIterator parse() {
        return this.output;
    }

    public long getReadCharacters() {
        return this.lexer.getReadCharacters();
    }

    private class Document
    extends RowIterator {
        private Document() {
        }

        @Override
        public boolean hasNext() {
            return CSVParser.this.lexer.getTokenType() != 3;
        }

        @Override
        public CellIterator next() {
            return new Row();
        }
    }

    private class Row
    extends CellIterator {
        private static final int STATE_INIT = 0;
        private static final int STATE_CELL = 1;
        private static final int STATE_SEPARATOR = 2;
        private static final int STATE_END = 3;
        private String next;
        private int state = 0;

        public Row() {
            this.findNext();
        }

        public void onStateInit() {
            this.next = CSVParser.this.lexer.next();
            int type = CSVParser.this.lexer.getTokenType();
            if (type == 0) {
                this.state = 1;
            } else if (type == 1) {
                this.next = "";
                this.state = 2;
            } else {
                this.next = null;
                this.state = 3;
            }
        }

        private void onStateCell() {
            this.next = CSVParser.this.lexer.next();
            int type = CSVParser.this.lexer.getTokenType();
            if (type == 1) {
                this.onStateSeparator();
            } else {
                this.next = null;
                this.state = 3;
            }
        }

        private void onStateSeparator() {
            this.next = CSVParser.this.lexer.next();
            int type = CSVParser.this.lexer.getTokenType();
            if (type == 0) {
                this.state = 1;
            } else if (type == 1) {
                this.next = "";
                this.state = 2;
            } else {
                this.next = "";
                this.state = 3;
            }
        }

        private void onStateEnd() {
            this.next = null;
        }

        private void findNext() {
            switch (this.state) {
                case 0: {
                    this.onStateInit();
                    break;
                }
                case 1: {
                    this.onStateCell();
                    break;
                }
                case 2: {
                    this.onStateSeparator();
                    break;
                }
                default: {
                    this.onStateEnd();
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public String next() {
            String value = this.next;
            this.findNext();
            return value;
        }
    }
}

