/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.databinding;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.properties.Activator;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalization;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.tools.databinding.ReferenceCountedObservable;

public class DiagramLabelObservableValue
extends AbstractObservableValue
implements IObserving,
ReferenceCountedObservable {
    private final ReferenceCountedObservable.Support refCount = new ReferenceCountedObservable.Support((IObservable)this);
    protected Diagram diagram;
    protected EditingDomain domain;
    protected Adapter listener;
    protected InternationalizationEntry entry;

    public DiagramLabelObservableValue(Diagram diagram, EditingDomain domain) {
        this(Realm.getDefault(), diagram, domain);
    }

    public DiagramLabelObservableValue(Realm realm, Diagram diagram, EditingDomain domain) {
        super(realm);
        this.diagram = diagram;
        this.domain = domain;
        this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)diagram, (Object)diagram);
    }

    public synchronized void dispose() {
        if (this.listener != null) {
            this.entry.eAdapters().remove((Object)this.listener);
            this.listener = null;
        }
        this.entry = null;
        this.diagram = null;
        super.dispose();
    }

    public Object getObserved() {
        return this.diagram;
    }

    protected void firstListenerAdded() {
        if (this.entry != null) {
            if (this.listener == null) {
                this.listener = new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        if (InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value() == notification.getFeature() && !notification.isTouch()) {
                            final ValueDiff diff = Diffs.createValueDiff((Object)notification.getOldValue(), (Object)notification.getNewValue());
                            DiagramLabelObservableValue.this.getRealm().exec(new Runnable(){

                                @Override
                                public void run() {
                                    DiagramLabelObservableValue.this.fireValueChange(diff);
                                }
                            });
                        }
                    }
                };
            }
            this.entry.eAdapters().add((Object)this.listener);
        }
    }

    protected Object doGetValue() {
        return LabelInternationalization.getInstance().getDiagramLabelWithoutName(this.diagram);
    }

    protected void doSetValue(Object value) {
        try {
            if (this.entry != null && this.listener != null) {
                this.entry.eAdapters().remove((Object)this.listener);
            }
            Command emfCommand = LabelInternationalization.getInstance().getSetDiagramLabelCommand(this.domain, this.diagram, (String)value, null);
            this.domain.getCommandStack().execute(emfCommand);
            this.entry = LabelInternationalizationUtils.getInternationalizationEntry((EObject)this.diagram, (Object)this.diagram);
            this.firstListenerAdded();
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public Object getValueType() {
        return null;
    }

    public void retain() {
        this.refCount.retain();
    }

    public void release() {
        this.refCount.release();
    }

    public void autorelease() {
        this.refCount.autorelease();
    }
}

