/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.hyperlink;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.infra.core.services.BadStateException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServiceNotFoundException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkSpecificObject;
import org.eclipse.papyrus.infra.hyperlink.service.HyperlinkContributor;
import org.eclipse.papyrus.infra.services.viewersearch.impl.ViewerSearchService;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;

public class DirectedRelationshipSourceHyperlinkContributor
implements HyperlinkContributor {
    public List<HyperLinkObject> getHyperlinks(Object fromElement) {
        ArrayList<HyperLinkObject> hyperlinks = new ArrayList<HyperLinkObject>();
        if (fromElement instanceof Element) {
            EList relationships = ((Element)fromElement).getTargetDirectedRelationships();
            ArrayList objectsInViews = new ArrayList();
            for (DirectedRelationship relationship : relationships) {
                for (Element source : relationship.getSources()) {
                    ViewerSearchService viewerSearchService;
                    block17: {
                        viewerSearchService = null;
                        try {
                            viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, (Object)((EObject)fromElement));
                        }
                        catch (ServiceException e) {
                            if (e instanceof ServiceNotFoundException) {
                                viewerSearchService = new ViewerSearchService();
                                try {
                                    viewerSearchService.startService();
                                    ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)fromElement).add(ViewerSearchService.class, 1, (IService)viewerSearchService);
                                }
                                catch (ServiceException e1) {
                                    Activator.log.error((Throwable)e1);
                                }
                            }
                            if (!(e instanceof BadStateException)) break block17;
                            try {
                                ServiceUtilsForEObject.getInstance().getServiceRegistry((EObject)fromElement).startRegistry();
                                viewerSearchService = (ViewerSearchService)ServiceUtilsForEObject.getInstance().getService(ViewerSearchService.class, (Object)((EObject)fromElement));
                            }
                            catch (Exception e1) {
                                Activator.log.error((Throwable)e1);
                            }
                        }
                    }
                    if (viewerSearchService == null) continue;
                    List viewerSearchResults = viewerSearchService.getViewersInCurrentModel((EObject)source, null, false, false);
                    objectsInViews.addAll(viewerSearchResults);
                }
            }
            TreeIterator allViewsOfActivatePage = null;
            View page = null;
            try {
                EObject emfPageId;
                Object pageId;
                IPage activePage = ((ISashWindowsContainer)ServiceUtilsForEObject.getInstance().getService(ISashWindowsContainer.class, (Object)((Element)fromElement))).getActiveSashWindowsPage();
                if (activePage != null && (pageId = activePage.getRawModel()) instanceof PageRef && (emfPageId = ((PageRef)pageId).getEmfPageIdentifier()) instanceof View) {
                    page = (View)emfPageId;
                }
            }
            catch (Exception e) {
                Activator.log.error((Throwable)e);
            }
            for (Object object : objectsInViews) {
                if (!(object instanceof View)) continue;
                boolean inActivePage = false;
                if (page != null) {
                    allViewsOfActivatePage = page.eAllContents();
                    while (allViewsOfActivatePage.hasNext()) {
                        EObject next = (EObject)allViewsOfActivatePage.next();
                        if (!(next instanceof View)) {
                            allViewsOfActivatePage.prune();
                            continue;
                        }
                        View nextView = (View)next;
                        if (!object.equals(nextView)) continue;
                        inActivePage = true;
                        break;
                    }
                }
                if (inActivePage) continue;
                HyperLinkSpecificObject hyperlink = new HyperLinkSpecificObject((EObject)object);
                hyperlinks.add((HyperLinkObject)hyperlink);
            }
        }
        return hyperlinks;
    }
}

