/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.editpolicies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ListCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeCompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.ShapeCompartmentFigure;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.DefaultNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.DropObjectsRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.commands.wrappers.CommandProxyWithResult;
import org.eclipse.papyrus.infra.gmfdiag.common.adapter.SemanticAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CommonDeferredCreateConnectionViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.CreateViewCommand;
import org.eclipse.papyrus.infra.gmfdiag.common.commands.SemanticElementAdapter;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.AbstractDiagramDragDropEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.service.visualtype.VisualTypeService;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramEditPartsUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ViewServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.dnd.policy.CustomizableDropEditPolicy;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;
import org.eclipse.papyrus.uml.diagram.common.commands.DeferredCreateCommand;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.SideAffixedNodesCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.helper.Element2IAdaptableRegistryHelper;
import org.eclipse.papyrus.uml.diagram.common.helper.ILinkMappingHelper;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public abstract class CommonDiagramDragDropEditPolicy
extends AbstractDiagramDragDropEditPolicy {
    private Element2IAdaptableRegistryHelper myElement2IAdaptableRegistryHelper;
    protected ILinkMappingHelper linkmappingHelper;

    public CommonDiagramDragDropEditPolicy(ILinkMappingHelper mappingHelper) {
        this.linkmappingHelper = mappingHelper;
    }

    public IElementType getUMLElementType(String elementID) {
        return VisualTypeService.getInstance().getElementType(this.getContextDiagram(), elementID);
    }

    public String getNodeVisualID(View containerView, EObject domainElement) {
        return VisualTypeService.getInstance().getNodeType(containerView, domainElement);
    }

    public String getLinkWithClassVisualID(EObject domainElement) {
        return VisualTypeService.getInstance().getLinkType(this.getContextDiagram(), domainElement);
    }

    protected Diagram getContextDiagram() {
        View view = (View)TypeUtils.as((Object)this.getHost().getModel(), View.class);
        return view == null ? null : view.getDiagram();
    }

    protected Element2IAdaptableRegistryHelper getElement2IAdaptableRegistryHelper() {
        if (this.myElement2IAdaptableRegistryHelper == null) {
            this.myElement2IAdaptableRegistryHelper = new Element2IAdaptableRegistryHelper();
        }
        return this.myElement2IAdaptableRegistryHelper;
    }

    protected Command createViewsAndArrangeCommand(DropObjectsRequest dropRequest, List viewDescriptors) {
        CreateViewRequest createViewRequest = new CreateViewRequest(viewDescriptors);
        createViewRequest.setLocation(dropRequest.getLocation());
        Command createCommand = this.getHost().getCommand((Request)createViewRequest);
        return createCommand;
    }

    public CompositeCommand dropBinaryLink(CompositeCommand cc, Element source, Element target, String linkVISUALID, Point absoluteLocation, Element semanticLink) {
        IAdaptable sourceAdapter = this.findAdapter(cc, source, this.getLinkSourceDropLocation(absoluteLocation, source, target));
        IAdaptable targetAdapter = this.findAdapter(cc, target, this.getLinkTargetDropLocation(absoluteLocation, source, target));
        SemanticElementAdapter adapter = new SemanticElementAdapter((EObject)semanticLink, this.getUMLElementType(linkVISUALID));
        CreateConnectionViewRequest.ConnectionViewDescriptor linkdescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)adapter, ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), this.getDiagramPreferencesHint());
        CommonDeferredCreateConnectionViewCommand aLinkCommand = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), ((IHintedType)this.getUMLElementType(linkVISUALID)).getSemanticHint(), sourceAdapter, targetAdapter, this.getViewer(), this.getDiagramPreferencesHint(), linkdescriptor, null);
        aLinkCommand.setElement((EObject)semanticLink);
        cc.compose((IUndoableOperation)aLinkCommand);
        return cc;
    }

    protected Point getLinkSourceDropLocation(Point absoluteLocation, Element source, Element target) {
        return absoluteLocation;
    }

    protected Point getLinkTargetDropLocation(Point absoluteLocation, Element source, Element target) {
        if (this.lookForEditPart((EObject)source) == null && this.lookForEditPart((EObject)target) == null) {
            return absoluteLocation.getTranslated(100, 0);
        }
        return absoluteLocation;
    }

    protected PreferencesHint getDiagramPreferencesHint() {
        return ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint();
    }

    public Command getDropObjectsCommand(DropObjectsRequest dropRequest) {
        ViewServiceUtil.forceLoad();
        if (dropRequest.getObjects().size() > 0 && dropRequest.getObjects().get(0) instanceof String) {
            return this.getDropFileCommand(dropRequest);
        }
        CompositeCommand cc = new CompositeCommand("Drop");
        for (EObject droppedObject : dropRequest.getObjects()) {
            if (droppedObject instanceof Element && this.getElement2IAdaptableRegistryHelper().findAdapter((Element)droppedObject) != null) continue;
            cc.add(this.getDropObjectCommand(dropRequest, droppedObject));
        }
        this.getElement2IAdaptableRegistryHelper().clear();
        return new ICommandProxy((ICommand)cc);
    }

    protected IUndoableOperation getDropObjectCommand(DropObjectsRequest dropRequest, EObject droppedObject) {
        Point location = dropRequest.getLocation().getCopy();
        IGraphicalEditPart parent = (IGraphicalEditPart)this.getHost();
        boolean isParentDiagram = this.getHost().getModel() instanceof Diagram;
        String nodeVISUALID = this.getNodeVisualID(parent.getNotationView(), droppedObject);
        String linkVISUALID = this.getLinkWithClassVisualID(droppedObject);
        if (this.getSpecificDrop().contains(nodeVISUALID) || this.getSpecificDrop().contains(linkVISUALID)) {
            if (!isParentDiagram && !this.isDropNonCanvasNodeAllowed(parent, droppedObject)) {
                return UnexecutableCommand.INSTANCE;
            }
            Command specificDropCommand = this.getSpecificDropCommand(dropRequest, (Element)droppedObject, nodeVISUALID, linkVISUALID);
            CompositeCommand cc = new CompositeCommand("Drop command");
            cc.compose((IUndoableOperation)new CommandProxy(specificDropCommand));
            if (this.isCopy(dropRequest)) {
                CompoundCommand specificDropCompoundCommand;
                ICommandProxy cp;
                if (specificDropCommand instanceof ICommandProxy) {
                    ICommandProxy specificDropCommandProxy = (ICommandProxy)specificDropCommand;
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, specificDropCommandProxy);
                } else if (specificDropCommand instanceof CompoundCommand && (cp = this.getCommandProxyFromCompoundCommand(specificDropCompoundCommand = (CompoundCommand)specificDropCommand)) != null) {
                    this.createDeferredCommandWithCommandResult(droppedObject, cc, cp);
                }
            }
            return cc;
        }
        if ((linkVISUALID == null || linkVISUALID.isEmpty()) && nodeVISUALID != null) {
            EObject graphicalParent = ((GraphicalEditPart)this.getHost()).resolveSemanticElement();
            if (isParentDiagram) {
                return this.getDefaultDropNodeCommand(nodeVISUALID, location, droppedObject, dropRequest);
            }
            if (graphicalParent instanceof Element && ((Element)graphicalParent).getOwnedElements().contains((Object)droppedObject) && this.isDropNonCanvasNodeAllowed(parent, droppedObject)) {
                return this.getDefaultDropNodeCommand(nodeVISUALID, location, droppedObject, dropRequest);
            }
            return UnexecutableCommand.INSTANCE;
        }
        if (linkVISUALID != null && !linkVISUALID.isEmpty()) {
            Collection<?> sources = this.linkmappingHelper.getSource((Element)droppedObject);
            Collection<?> targets = this.linkmappingHelper.getTarget((Element)droppedObject);
            if (sources.size() == 0 || targets.size() == 0) {
                return UnexecutableCommand.INSTANCE;
            }
            Element source = (Element)sources.toArray()[0];
            Element target = (Element)targets.toArray()[0];
            CompositeCommand cc = new CompositeCommand("Add Link");
            this.dropBinaryLink(cc, source, target, linkVISUALID, location, (Element)droppedObject);
            return cc;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean isDropNonCanvasNodeAllowed(IGraphicalEditPart parent, EObject droppedObject) {
        Property property;
        Element owner;
        if (this.isListCompartmentContainsDroppedObject(parent, droppedObject)) {
            return false;
        }
        return !(droppedObject instanceof Property) || !((owner = (property = (Property)droppedObject).getOwner()) instanceof Association) || owner instanceof AssociationClass;
    }

    private boolean isListCompartmentContainsDroppedObject(IGraphicalEditPart parent, EObject droppedObject) {
        if (!(parent instanceof ListCompartmentEditPart)) {
            return false;
        }
        List childs = parent.getChildren();
        for (EditPart nextChild : childs) {
            EObject nextChildSemantic;
            if (!(nextChild instanceof GraphicalEditPart) || (nextChildSemantic = ((GraphicalEditPart)nextChild).resolveSemanticElement()) != droppedObject) continue;
            return true;
        }
        return false;
    }

    protected ICommandProxy getCommandProxyFromCompoundCommand(CompoundCommand cc) {
        if (cc != null && cc.getCommands() != null) {
            for (Object command : cc.getCommands()) {
                if (command instanceof ICommandProxy) {
                    return (ICommandProxy)command;
                }
                if (!(command instanceof CompoundCommand)) continue;
                this.getCommandProxyFromCompoundCommand((CompoundCommand)command);
            }
        }
        return null;
    }

    protected void createDeferredCommandWithCommandResult(EObject droppedObject, CompositeCommand cc, ICommandProxy specificDropCommandProxy) {
        if (specificDropCommandProxy != null && specificDropCommandProxy.getICommand() != null && specificDropCommandProxy.getICommand().getCommandResult() != null && specificDropCommandProxy.getICommand().getCommandResult().getReturnValue() != null) {
            Object object = specificDropCommandProxy.getICommand().getCommandResult().getReturnValue();
            if (object instanceof CreateViewRequest.ViewDescriptor) {
                cc.compose((IUndoableOperation)this.createDeferredCreateCommand(droppedObject, (CreateViewRequest.ViewDescriptor)object));
            } else if (object instanceof Collection) {
                for (Object o : (Collection)object) {
                    if (!(o instanceof CreateViewRequest.ViewDescriptor)) continue;
                    cc.compose((IUndoableOperation)this.createDeferredCreateCommand(droppedObject, (CreateViewRequest.ViewDescriptor)o));
                }
            }
        }
    }

    private DeferredCreateCommand createDeferredCreateCommand(EObject droppedObject, CreateViewRequest.ViewDescriptor viewDescriptor) {
        return new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)viewDescriptor, this.getHost().getViewer());
    }

    protected Point getTranslatedToRelative(Point absoluteLocation) {
        Point relativeLocation = absoluteLocation.getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)relativeLocation);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)relativeLocation);
        relativeLocation.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
        return relativeLocation;
    }

    protected ICommand getDefaultDropNodeCommand(String nodeVISUALID, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        return this.getDefaultDropNodeCommand((EditPart)this.getHost(), nodeVISUALID, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(String nodeVISUALID, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(nodeVISUALID, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand((EditPart)this.getHost(), null, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(hostEP, null, absoluteLocation, droppedObject);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, String semanticHint, Point absoluteLocation, EObject droppedObject) {
        return this.getDefaultDropNodeCommand(hostEP, semanticHint, absoluteLocation, droppedObject, null);
    }

    protected ICommand getDefaultDropNodeCommand(EditPart hostEP, String semanticHint, Point absoluteLocation, EObject droppedObject, DropObjectsRequest request) {
        DiagramEditPartsUtil.findViews((EObject)droppedObject, (EditPartViewer)this.getViewer());
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, semanticHint, -1, true, this.getDiagramPreferencesHint());
        CreateViewRequest createViewRequest = new CreateViewRequest(descriptor);
        createViewRequest.setLocation(absoluteLocation);
        Command command = hostEP.getCommand((Request)createViewRequest);
        if (this.isCopy(request) && createViewRequest.getNewObject() instanceof List) {
            for (Object object : (List)createViewRequest.getNewObject()) {
                if (!(object instanceof IAdaptable)) continue;
                DeferredCreateCommand createCommand2 = new DeferredCreateCommand(this.getEditingDomain(), droppedObject, (IAdaptable)object, this.getHost().getViewer());
                command.chain((Command)new ICommandProxy((ICommand)createCommand2));
            }
        }
        CommandProxyWithResult result = new CommandProxyWithResult(command, (Object)descriptor);
        if (droppedObject instanceof Element) {
            this.getElement2IAdaptableRegistryHelper().registerAdapter((Element)droppedObject, (IAdaptable)result.getCommandResult().getReturnValue());
        }
        return result;
    }

    public boolean isCopy(DropObjectsRequest dropRequest) {
        int eventDetail;
        return dropRequest != null && dropRequest.getExtendedData() != null && dropRequest.getExtendedData().get("EVENT_DETAIL") instanceof Integer && ((eventDetail = ((Integer)dropRequest.getExtendedData().get("EVENT_DETAIL")).intValue()) & 1) != 0;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected Command getSpecificDropCommand(DropObjectsRequest dropRequest, Element semanticLink, String nodeVISUALID, String linkVISUALID) {
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected EditPartViewer getViewer() {
        return ((IGraphicalEditPart)this.getHost()).getViewer();
    }

    protected EditPart lookForEditPart(EObject semantic) {
        Collection editPartSet = this.getHost().getViewer().getEditPartRegistry().values();
        Iterator editPartIterator = editPartSet.iterator();
        EditPart existedEditPart = null;
        while (editPartIterator.hasNext() && existedEditPart == null) {
            EditPart currentEditPart = (EditPart)editPartIterator.next();
            if (!this.isEditPartTypeAdapted(currentEditPart.getClass(), semantic.eClass()) || !semantic.equals(((GraphicalEditPart)currentEditPart).resolveSemanticElement())) continue;
            existedEditPart = currentEditPart;
        }
        return existedEditPart;
    }

    private boolean isEditPartTypeAdapted(Class<? extends EditPart> editPartClass, EClass eClass) {
        if (DefaultNodeEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (DiagramEditPart.class.isAssignableFrom(editPartClass) || CompartmentEditPart.class.isAssignableFrom(editPartClass)) {
            return false;
        }
        if (GraphicalEditPart.class.isAssignableFrom(editPartClass)) {
            return this.isEditPartTypeSuitableForEClass(editPartClass.asSubclass(GraphicalEditPart.class), eClass);
        }
        return false;
    }

    protected boolean isEditPartTypeSuitableForEClass(Class<? extends GraphicalEditPart> editPartClass, EClass eClass) {
        return true;
    }

    protected Command getDropConstraintCommand(Constraint constraint, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView, IHintedType commentType, IHintedType linkForComment) {
        CompositeCommand cc = new CompositeCommand("dropConstraint");
        int nbAnnotated = constraint.getConstrainedElements().size();
        ArrayList endToConnect = new ArrayList(constraint.getConstrainedElements());
        GraphicalEditPart[] endEditPart = new GraphicalEditPart[nbAnnotated];
        Iterator iteratorProp = endToConnect.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            Element currentAnnotatedElement = (Element)iteratorProp.next();
            endEditPart[index] = (GraphicalEditPart)this.lookForEditPart((EObject)currentAnnotatedElement);
            ++index;
        }
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)constraint);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, commentType.getSemanticHint(), -1, true, diagramPreferencesHint);
        CreateCommand nodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, containerView);
        cc.compose((IUndoableOperation)nodeCreationCommand);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), location);
        cc.compose((IUndoableOperation)setBoundsCommand);
        if (nbAnnotated != 0) {
            IAdaptable sourceEventAdapter = null;
            SemanticAdapter targetEventAdapter = null;
            sourceEventAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
            CreateConnectionViewRequest.ConnectionViewDescriptor dashedLineViewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)linkForComment, linkForComment.getSemanticHint(), diagramPreferencesHint);
            GraphicalEditPart[] graphicalEditPartArray = endEditPart;
            int n = endEditPart.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicalEditPart current = graphicalEditPartArray[n2];
                if (current != null) {
                    targetEventAdapter = new SemanticAdapter(null, current.getModel());
                    CommonDeferredCreateConnectionViewCommand dashedLineCmd = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), linkForComment.getSemanticHint(), sourceEventAdapter, (IAdaptable)targetEventAdapter, viewer, diagramPreferencesHint, dashedLineViewDescriptor, null);
                    dashedLineCmd.setElement(null);
                    if (dashedLineCmd.canExecute()) {
                        cc.compose((IUndoableOperation)dashedLineCmd);
                    }
                }
                ++n2;
            }
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected Command getDropCommentCommand(Comment comment, EditPartViewer viewer, PreferencesHint diagramPreferencesHint, Point location, View containerView, IHintedType commentType, IHintedType linkForComment) {
        ViewServiceUtil.forceLoad();
        CompositeCommand cc = new CompositeCommand("dropComment");
        int nbAnnotated = comment.getAnnotatedElements().size();
        ArrayList endToConnect = new ArrayList(comment.getAnnotatedElements());
        GraphicalEditPart[] endEditPart = new GraphicalEditPart[nbAnnotated];
        Iterator iteratorProp = endToConnect.iterator();
        int index = 0;
        while (iteratorProp.hasNext()) {
            Element currentAnnotatedElement = (Element)iteratorProp.next();
            endEditPart[index] = (GraphicalEditPart)this.lookForEditPart((EObject)currentAnnotatedElement);
            ++index;
        }
        EObjectAdapter elementAdapter = new EObjectAdapter((EObject)comment);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, commentType.getSemanticHint(), -1, true, diagramPreferencesHint);
        CreateCommand nodeCreationCommand = new CreateCommand(this.getEditingDomain(), descriptor, containerView);
        cc.compose((IUndoableOperation)nodeCreationCommand);
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue(), location);
        cc.compose((IUndoableOperation)setBoundsCommand);
        IAdaptable sourceEventAdapter = (IAdaptable)nodeCreationCommand.getCommandResult().getReturnValue();
        SemanticAdapter targetEventAdapter = null;
        if (nbAnnotated != 0) {
            CreateConnectionViewRequest.ConnectionViewDescriptor dashedLineViewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor((IAdaptable)linkForComment, linkForComment.getSemanticHint(), diagramPreferencesHint);
            GraphicalEditPart[] graphicalEditPartArray = endEditPart;
            int n = endEditPart.length;
            int n2 = 0;
            while (n2 < n) {
                GraphicalEditPart current = graphicalEditPartArray[n2];
                if (current != null) {
                    targetEventAdapter = new SemanticAdapter(null, current.getModel());
                    CommonDeferredCreateConnectionViewCommand dashedLineCmd = new CommonDeferredCreateConnectionViewCommand(this.getEditingDomain(), linkForComment.getSemanticHint(), sourceEventAdapter, (IAdaptable)targetEventAdapter, viewer, diagramPreferencesHint, dashedLineViewDescriptor, null);
                    dashedLineCmd.setElement(null);
                    if (dashedLineCmd.canExecute()) {
                        cc.compose((IUndoableOperation)dashedLineCmd);
                    }
                }
                ++n2;
            }
        }
        return new ICommandProxy((ICommand)cc);
    }

    protected Point getTranslatedLocation(DropObjectsRequest dropRequest) {
        Point location = dropRequest.getLocation().getCopy();
        ((GraphicalEditPart)this.getHost()).getContentPane().translateToRelative((Translatable)location);
        ((GraphicalEditPart)this.getHost()).getContentPane().translateFromParent((Translatable)location);
        location.translate(((GraphicalEditPart)this.getHost()).getContentPane().getClientArea().getLocation().getNegated());
        return location;
    }

    protected Command dropAffixedNode(DropObjectsRequest dropRequest, Element droppedElement, String nodeVISUALID) {
        EObject graphicalParentObject;
        if (!(droppedElement instanceof Port) && !(droppedElement instanceof Parameter)) {
            return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
        }
        Boolean isCompartmentTarget = false;
        GraphicalEditPart graphicalParentEditPart = (GraphicalEditPart)this.getHost();
        Point dropLocation = dropRequest.getLocation().getCopy();
        if (graphicalParentEditPart instanceof ShapeCompartmentEditPart) {
            isCompartmentTarget = true;
            graphicalParentEditPart = (GraphicalEditPart)graphicalParentEditPart.getParent();
            Point targetLocation = graphicalParentEditPart.getContentPane().getBounds().getLocation();
            ShapeCompartmentFigure compartmentFigure = (ShapeCompartmentFigure)this.getHostFigure();
            Viewport compartmentViewPort = compartmentFigure.getScrollPane().getViewport();
            Point compartmentViewPortLocation = compartmentViewPort.getLocation();
            Point compartmentViewPortViewLocation = compartmentViewPort.getViewLocation();
            Point delta = compartmentViewPortLocation.translate(targetLocation.negate());
            delta = delta.translate(compartmentViewPortViewLocation.negate());
            dropLocation = dropRequest.getLocation().getTranslated(delta);
        }
        if (!this.isSideAffixedNodesCreationPolicyInstalled((IGraphicalEditPart)graphicalParentEditPart)) {
            Point parentLoc = graphicalParentEditPart.getFigure().getBounds().getLocation().getCopy();
            PortPositionLocator locator = new PortPositionLocator(graphicalParentEditPart.getFigure());
            Rectangle proposedBounds = new Rectangle(dropLocation, new Dimension(20, 20));
            proposedBounds = proposedBounds.getTranslated(parentLoc);
            Rectangle preferredBounds = locator.getPreferredLocation(proposedBounds);
            Rectangle creationBounds = preferredBounds.getTranslated(parentLoc.getNegated());
            dropLocation = creationBounds.getLocation();
        }
        if ((graphicalParentObject = graphicalParentEditPart.resolveSemanticElement()) instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)graphicalParentObject).getAllAttributes().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        if (graphicalParentObject instanceof ConnectableElement) {
            Type type = ((ConnectableElement)graphicalParentObject).getType();
            if (type != null && type instanceof EncapsulatedClassifier && ((EncapsulatedClassifier)type).getAllAttributes().contains((Object)droppedElement)) {
                if (isCompartmentTarget.booleanValue()) {
                    return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
                }
                return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
            }
        } else if (graphicalParentObject instanceof Behavior && ((Behavior)graphicalParentObject).getOwnedParameters().contains((Object)droppedElement)) {
            if (isCompartmentTarget.booleanValue()) {
                return this.getDropAffixedNodeInCompartmentCommand(nodeVISUALID, dropLocation, (EObject)droppedElement);
            }
            return new ICommandProxy(this.getDefaultDropNodeCommand(nodeVISUALID, dropLocation, (EObject)droppedElement));
        }
        return org.eclipse.gef.commands.UnexecutableCommand.INSTANCE;
    }

    protected CompoundCommand getDropAffixedNodeInCompartmentCommand(String nodeVISUALID, Point location, EObject droppedObject) {
        CompoundCommand cc = new CompoundCommand("Drop");
        EObjectAdapter elementAdapter = new EObjectAdapter(droppedObject);
        CreateViewRequest.ViewDescriptor descriptor = new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, ((IHintedType)this.getUMLElementType(nodeVISUALID)).getSemanticHint(), -1, true, this.getDiagramPreferencesHint());
        CreateViewCommand createCommand = new CreateViewCommand(this.getEditingDomain(), descriptor, (View)this.getHost().getParent().getModel());
        cc.add((Command)new ICommandProxy((ICommand)createCommand));
        SetBoundsCommand setBoundsCommand = new SetBoundsCommand(this.getEditingDomain(), "move", (IAdaptable)createCommand.getCommandResult().getReturnValue(), location);
        cc.add((Command)new ICommandProxy((ICommand)setBoundsCommand));
        return cc;
    }

    private boolean isSideAffixedNodesCreationPolicyInstalled(IGraphicalEditPart editPart) {
        EditPolicy policy = editPart.getEditPolicy((Object)"CreationPolicy");
        if (policy == null && !(policy instanceof CustomizableDropEditPolicy)) {
            return false;
        }
        EditPolicy defaultCreationPolicy = ((CustomizableDropEditPolicy)policy).getDefaultCreationPolicy();
        return defaultCreationPolicy != null && defaultCreationPolicy instanceof SideAffixedNodesCreationEditPolicy;
    }

    private IAdaptable findAdapter(CompositeCommand cc, Element source, Point dropLocation) {
        IAdaptable result = this.getElement2IAdaptableRegistryHelper().findAdapter(source);
        if (result != null) {
            return result;
        }
        GraphicalEditPart editPart = (GraphicalEditPart)this.lookForEditPart((EObject)source);
        if (editPart == null) {
            ICommand createCommand = this.getDefaultDropNodeCommand(dropLocation, (EObject)source);
            cc.add((IUndoableOperation)createCommand);
            result = (IAdaptable)createCommand.getCommandResult().getReturnValue();
            return result;
        }
        return new SemanticAdapter(null, editPart.getModel());
    }
}

