/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.RobotML;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ServiceFlowKind implements Enumerator
{
    PROVIDED(0, "provided", "provided"),
    REQUIRED(1, "required", "required");

    public static final int PROVIDED_VALUE = 0;
    public static final int REQUIRED_VALUE = 1;
    private static final ServiceFlowKind[] VALUES_ARRAY;
    public static final List<ServiceFlowKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ServiceFlowKind[]{PROVIDED, REQUIRED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ServiceFlowKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ServiceFlowKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ServiceFlowKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ServiceFlowKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ServiceFlowKind get(int value) {
        switch (value) {
            case 0: {
                return PROVIDED;
            }
            case 1: {
                return REQUIRED;
            }
        }
        return null;
    }

    private ServiceFlowKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

