/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.animation.engine.animators;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.moka.animation.engine.animators.Animator;
import org.eclipse.papyrus.moka.animation.engine.animators.actions.DerivedAnimationAction;
import org.eclipse.papyrus.moka.animation.engine.rendering.AnimationEngine;

public class AnimatorExtensionEvaluator {
    private static final String ANIMATOR_ID = "org.eclipse.papyrus.moka.kernel.animation.animator";
    private static final String REDEFINED_ATTR = "redefined";
    private static final String PRIORITY_ATTR = "priority";
    private static final String CLASS_ATTR = "class";
    private static final String DERIVED_ACTIONS_ATTR = "derivedAnimationAction";

    public static List<Animator> evaluateAnimators(AnimationEngine engine) {
        ArrayList<Animator> animators = new ArrayList<Animator>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] configurations = registry.getConfigurationElementsFor(ANIMATOR_ID);
        if (configurations.length > 0) {
            Set<String> redefinedAnimator = AnimatorExtensionEvaluator.getRedefinedAnimator(configurations);
            IConfigurationElement[] iConfigurationElementArray = configurations;
            int n = configurations.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configuration = iConfigurationElementArray[n2];
                String clazz = configuration.getAttribute(CLASS_ATTR);
                if (!redefinedAnimator.contains(clazz)) {
                    animators.add(AnimatorExtensionEvaluator.createAnimator(configuration, engine));
                }
                ++n2;
            }
        }
        return animators;
    }

    private static Set<String> getRedefinedAnimator(IConfigurationElement[] configurations) {
        HashSet<String> redefinedAnimator = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configuration = iConfigurationElementArray[n2];
            String redefined = configuration.getAttribute(REDEFINED_ATTR);
            if (redefined != null && !redefined.isEmpty()) {
                redefinedAnimator.add(redefined);
            }
            ++n2;
        }
        return redefinedAnimator;
    }

    private static Animator createAnimator(IConfigurationElement configuration, AnimationEngine engine) {
        Animator animator = null;
        if (configuration != null) {
            try {
                animator = (Animator)configuration.createExecutableExtension(CLASS_ATTR);
                animator.setAnimationEngine(engine);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            if (animator != null) {
                String prioritySpecification = configuration.getAttribute(PRIORITY_ATTR);
                if (prioritySpecification != null && !prioritySpecification.isEmpty()) {
                    int priority = 0;
                    try {
                        priority = Integer.parseInt(prioritySpecification);
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    animator.setPriority(priority);
                } else {
                    animator.setPriority(0);
                }
                animator.setDerivedAnimationAction(AnimatorExtensionEvaluator.evaluateDerivedActions(configuration.getChildren(DERIVED_ACTIONS_ATTR)));
            }
        }
        return animator;
    }

    private static List<DerivedAnimationAction> evaluateDerivedActions(IConfigurationElement[] contributions) {
        ArrayList<DerivedAnimationAction> derivedActions = new ArrayList<DerivedAnimationAction>();
        IConfigurationElement[] iConfigurationElementArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement contribution = iConfigurationElementArray[n2];
            DerivedAnimationAction derivedAction = null;
            try {
                derivedAction = (DerivedAnimationAction)contribution.createExecutableExtension(CLASS_ATTR);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            derivedActions.add(derivedAction);
            ++n2;
        }
        return derivedActions;
    }
}

