/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.model.data.mapping.values;

import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.papyrus.moka.debug.engine.MokaDebugTarget;
import org.eclipse.papyrus.moka.debug.model.data.mapping.values.MokaValueAdapter;
import org.eclipse.papyrus.moka.debug.model.data.mapping.variables.FeatureValueVariableAdapter;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IFeatureValue;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IReference;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IStructuredValue;
import org.eclipse.uml2.uml.Classifier;

public class StructuredValueAdapter
extends MokaValueAdapter {
    protected IStructuredValue value;

    public StructuredValueAdapter(MokaDebugTarget debugTarget, IStructuredValue value) {
        super(debugTarget);
        this.value = value;
    }

    public String getReferenceTypeName() throws DebugException {
        String type = "[";
        Iterator typeIterator = this.value.getTypes().iterator();
        while (typeIterator.hasNext()) {
            Classifier classifier = (Classifier)typeIterator.next();
            type = String.valueOf(type) + classifier.getName();
            if (!typeIterator.hasNext()) continue;
            type = String.valueOf(type) + ", ";
        }
        type = String.valueOf(type) + "]";
        return type;
    }

    public String getValueString() throws DebugException {
        if (this.value instanceof IReference) {
            return ((IReference)this.value).getReferent().getIdentifier();
        }
        return this.value.toString();
    }

    @Override
    public IVariable[] getVariables() throws DebugException {
        if (this.variables.isEmpty()) {
            Iterator featureValueIterator = this.value.getFeatureValues().iterator();
            while (featureValueIterator.hasNext()) {
                this.variables.add(new FeatureValueVariableAdapter(this.debugTarget, this.value, (IFeatureValue)featureValueIterator.next()));
            }
        }
        return this.variables.toArray(new IVariable[0]);
    }
}

