/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.debug.breakpoint;

import java.util.MissingResourceException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.moka.utils.helper.EditorUtils;
import org.eclipse.ui.IEditorPart;
import org.eclipse.uml2.uml.NamedElement;

public class MokaBreakpoint
extends Breakpoint {
    protected EObject modelElement;
    protected static ResourceSet defaultResourceSet;

    public String getModelIdentifier() {
        return "org.eclipse.papyrus.moka.debug";
    }

    public EObject getModelElement() {
        return this.modelElement;
    }

    public void toggleBreakpoint(EObject modelElement) {
        String uri = modelElement.eResource().getURI().toString();
        String fragment = modelElement.eResource().getURIFragment(modelElement);
        IResource iresource = MokaBreakpoint.getIResource(modelElement.eResource());
        this.modelElement = modelElement;
        try {
            if (iresource != null) {
                IMarker marker = iresource.createMarker("org.eclipse.papyrus.moka.breakpointmarker");
                marker.setAttribute("uri", (Object)(String.valueOf(uri) + "#" + fragment));
                marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
                this.setMarker(marker);
                this.setEnabled(true);
                this.setPersisted(true);
            }
        }
        catch (CoreException ce) {
            Activator.log.error((Throwable)ce);
        }
    }

    public static IResource getIResource(Resource resource) {
        if (resource == null) {
            return null;
        }
        String uriPath = resource.getURI().toPlatformString(true);
        if (uriPath == null) {
            return null;
        }
        IFile iresource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uriPath));
        if (iresource != null && iresource.exists()) {
            return iresource;
        }
        return null;
    }

    public String getLabel() {
        String label = "";
        if (this.modelElement instanceof NamedElement) {
            return ((NamedElement)this.modelElement).getQualifiedName();
        }
        return label;
    }

    public void setMarker(IMarker marker) throws CoreException {
        if (this.modelElement == null) {
            this.modelElement = MokaBreakpoint.getEObjectOfMarker(marker);
        }
        super.setMarker(marker);
    }

    public static EObject getEObjectOfMarker(IMarker marker) {
        URI uriOfMarker = MokaBreakpoint.getURI(marker);
        if (uriOfMarker != null) {
            try {
                ServicesRegistry servicesRegistry;
                EObject modelElement = null;
                IEditorPart part = EditorUtils.getEditorPart((String)uriOfMarker.trimFragment().toString());
                if (part != null && (servicesRegistry = (ServicesRegistry)part.getAdapter(ServicesRegistry.class)) != null) {
                    try {
                        ResourceSet resourceSet = (ResourceSet)servicesRegistry.getService(ModelSet.class);
                        modelElement = resourceSet.getEObject(uriOfMarker, true);
                        if (modelElement != null) {
                            return modelElement;
                        }
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                    }
                }
                if (defaultResourceSet == null) {
                    defaultResourceSet = new ResourceSetImpl();
                }
                defaultResourceSet.getResource(uriOfMarker.trimFragment(), true);
                return defaultResourceSet.getEObject(uriOfMarker, true);
            }
            catch (MissingResourceException e) {
                Activator.log.error((Throwable)e);
            }
        }
        return null;
    }

    public static URI getURI(IMarker marker) {
        String uriOfMarkerStr = marker.getAttribute("uri", null);
        if (uriOfMarkerStr != null) {
            return URI.createURI((String)uriOfMarkerStr);
        }
        return null;
    }
}

