/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.InvocationActions.CS_ConstructStrategy;
import org.eclipse.papyrus.moka.composites.Semantics.impl.CompositeStructures.StructuredClasses.CS_Reference;
import org.eclipse.papyrus.moka.composites.interfaces.Semantics.CompositeStructures.InvocationActions.ICS_CallOperationActionActivation;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IObject_;
import org.eclipse.papyrus.moka.fuml.Semantics.Classes.Kernel.IValue;
import org.eclipse.papyrus.moka.fuml.Semantics.CommonBehaviors.BasicBehaviors.IExecution;
import org.eclipse.papyrus.moka.fuml.Semantics.Loci.LociL1.ILocus;
import org.eclipse.papyrus.moka.fuml.Semantics.impl.Actions.BasicActions.CallOperationActionActivation;
import org.eclipse.uml2.uml.CallOperationAction;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.ParameterDirectionKind;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;

public class CS_CallOperationActionActivation
extends CallOperationActionActivation
implements ICS_CallOperationActionActivation {
    public void doAction() {
        CallOperationAction action = (CallOperationAction)this.node;
        if (action.getOnPort() == null && this.isCreate(action.getOperation()) && action.getOperation().getMethods().size() == 0) {
            ILocus locus = this.getExecutionLocus();
            CS_ConstructStrategy strategy = (CS_ConstructStrategy)locus.getFactory().getStrategy("constructStrategy");
            IValue target = (IValue)this.takeTokens(action.getTarget()).get(0);
            if (target instanceof CS_Reference) {
                strategy.construct(action.getOperation(), ((CS_Reference)target).compositeReferent);
                EList parameters = action.getOperation().getOwnedParameters();
                EList resultPins = action.getResults();
                ArrayList<IValue> values = new ArrayList<IValue>();
                values.add(target);
                int i = 1;
                while (i <= parameters.size()) {
                    Parameter parameter = (Parameter)parameters.get(i - 1);
                    if (parameter.getDirection() == ParameterDirectionKind.RETURN_LITERAL) {
                        OutputPin resultPin = (OutputPin)resultPins.get(0);
                        this.putTokens(resultPin, values);
                    }
                    ++i;
                }
            }
        } else {
            super.doAction();
        }
    }

    public IExecution getCallExecution() {
        CallOperationAction action = (CallOperationAction)this.node;
        IExecution execution = null;
        if (action.getOnPort() == null) {
            execution = super.getCallExecution();
        } else {
            IValue target = (IValue)this.takeTokens(action.getTarget()).get(0);
            if (target instanceof CS_Reference) {
                CS_Reference targetReference = (CS_Reference)target;
                IObject_ executionContext = this.group.getActivityExecution().getContext();
                boolean operationIsOnProvidedInterface = this.isOperationProvided(action.getOnPort(), action.getOperation());
                boolean operationIsOnRequiredInterface = this.isOperationRequired(action.getOnPort(), action.getOperation());
                if (operationIsOnProvidedInterface && !operationIsOnRequiredInterface) {
                    execution = targetReference.dispatchIn(action.getOperation(), action.getOnPort());
                } else if (!operationIsOnProvidedInterface && operationIsOnRequiredInterface) {
                    if (executionContext == targetReference.getReferent() || targetReference.getCompositeReferent().contains(executionContext).booleanValue()) {
                        execution = targetReference.dispatchOut(action.getOperation(), action.getOnPort());
                    }
                } else if (operationIsOnProvidedInterface && operationIsOnRequiredInterface) {
                    execution = executionContext == targetReference.getReferent() || targetReference.getCompositeReferent().contains(executionContext) != false ? targetReference.dispatchOut(action.getOperation(), action.getOnPort()) : targetReference.dispatchIn(action.getOperation(), action.getOnPort());
                }
            }
        }
        return execution;
    }

    public boolean isOperationProvided(Port port, Operation operation) {
        boolean isProvided = false;
        if (operation.getOwner() instanceof Interface) {
            Integer interfaceIndex = 1;
            EList providedInterfaces = port.getProvideds();
            while (interfaceIndex <= providedInterfaces.size() && !isProvided) {
                Interface interface_ = (Interface)providedInterfaces.get(interfaceIndex - 1);
                Integer memberIndex = 1;
                while (memberIndex <= interface_.getMembers().size() && !isProvided) {
                    NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                    if (cddOperation instanceof Operation) {
                        isProvided = operation == cddOperation;
                    }
                    memberIndex = memberIndex + 1;
                }
                interfaceIndex = interfaceIndex + 1;
            }
        }
        return isProvided;
    }

    public boolean isOperationRequired(Port port, Operation operation) {
        boolean isRequired = false;
        Integer interfaceIndex = 1;
        EList requiredInterfaces = port.getRequireds();
        while (interfaceIndex <= requiredInterfaces.size() && !isRequired) {
            Interface interface_ = (Interface)requiredInterfaces.get(interfaceIndex - 1);
            Integer memberIndex = 1;
            while (memberIndex <= interface_.getMembers().size() && !isRequired) {
                NamedElement cddOperation = (NamedElement)interface_.getMembers().get(memberIndex - 1);
                if (cddOperation instanceof Operation) {
                    isRequired = operation == cddOperation;
                }
                memberIndex = memberIndex + 1;
            }
            interfaceIndex = interfaceIndex + 1;
        }
        return isRequired;
    }

    public boolean isCreate(Operation o) {
        EList appliedStereotypes = o.getAppliedStereotypes();
        int i = 0;
        boolean isCreate = false;
        while (i < appliedStereotypes.size() && !isCreate) {
            Stereotype s = (Stereotype)appliedStereotypes.get(i);
            if (!s.getName().equals("Create")) continue;
            isCreate = true;
        }
        return isCreate;
    }
}

