/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.service;

import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationModel;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayerStackApplicationSynchronizer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model.LayersModelResource;

public class LayersApplicationService
implements IService {
    public static final String SERVICEID = "org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.service.LayersApplicationService";
    protected ModelSet modelSet;
    protected LayerStackApplicationSynchronizer layersSynchronizer;
    private LayersModelResource layersModel;
    private NotationModel notationModel;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.modelSet = (ModelSet)servicesRegistry.getService(ModelSet.class);
    }

    public void startService() throws ServiceException {
        boolean isAlreadyExist;
        try {
            this.layersModel = (LayersModelResource)this.modelSet.getModelChecked("org.eclipse.papyrus.layers.resource.LayersModel");
            this.notationModel = (NotationModel)this.modelSet.getModelChecked("org.eclipse.papyrus.infra.core.resource.notation.NotationModel");
        }
        catch (NotFoundException e) {
            throw new ServiceException("Can't get layer model", (Throwable)e);
        }
        catch (ClassCastException e) {
            throw new ServiceException("layersModel should be of type LayersModel", (Throwable)e);
        }
        LayersStackApplication application = (LayersStackApplication)this.layersModel.getModelRoot();
        boolean bl = isAlreadyExist = application != null;
        if (Activator.log.isDebugEnabled()) {
            if (isAlreadyExist) {
                Activator.log.debug("LayerApplication already exist in modelSet");
            } else {
                Activator.log.debug("LayerApplication do not exist in modelSet");
            }
        }
        this.layersSynchronizer = new LayerStackApplicationSynchronizer(this.layersModel, this.notationModel);
    }

    public void disposeService() throws ServiceException {
        this.layersSynchronizer.dispose();
        this.layersSynchronizer = null;
        this.layersModel = null;
        this.modelSet = null;
    }
}

