/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.model;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.impl.BasicEObjectImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.AbstractModelWithSharedResource;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersFactory;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayersStackAndApplicationLifeCycleEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.resource.utils.DanglingCrossReferencer;

public class LayersModelResource
extends AbstractModelWithSharedResource<LayersStackApplication>
implements IModel {
    public static final String LAYERS_RESOURCE_FILE_EXTENSION = "layers";
    public static final String MODEL_ID = "org.eclipse.papyrus.layers.resource.LayersModel";
    private LayersStackAndApplicationLifeCycleEventNotifier layersStackAndApplicationLifeCycleEventNotifier = null;

    public LayersModelResource() {
        this.modelKind = AbstractModelWithSharedResource.ModelKind.slave;
    }

    public String getIdentifier() {
        return MODEL_ID;
    }

    protected String getModelFileExtension() {
        return LAYERS_RESOURCE_FILE_EXTENSION;
    }

    protected boolean isModelRoot(EObject object) {
        return object instanceof LayersStackApplication;
    }

    public void loadModel(URI uriWithoutExtension) {
        if (this.exists(uriWithoutExtension)) {
            try {
                super.loadModel(uriWithoutExtension);
            }
            catch (Exception e) {
                this.createModel(uriWithoutExtension);
            }
        }
        if (this.resource == null) {
            this.createModel(uriWithoutExtension);
        }
        try {
            this.saveModel();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean shouldSave() {
        return this.resource.isModified();
    }

    public void saveModel() throws IOException {
        if (this.shouldSave()) {
            ModelSet set = this.getModelManager();
            for (Resource resource : this.getResources()) {
                if (!set.shouldSave(resource)) continue;
                try {
                    DanglingCrossReferencer danglingReferencer = new DanglingCrossReferencer(resource);
                    Map<EObject, Collection<EStructuralFeature.Setting>> danglingReferences = danglingReferencer.findDanglingCrossReferences();
                    if (danglingReferences.size() > 0) {
                        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> danglingReferenceEntry : danglingReferences.entrySet()) {
                            BasicEObjectImpl danglingReference = (BasicEObjectImpl)danglingReferenceEntry.getKey();
                            for (EStructuralFeature.Setting setting : danglingReferenceEntry.getValue()) {
                                EObject objectWithDanglingRefs = setting.getEObject();
                                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)objectWithDanglingRefs);
                                Command addThePart = RemoveCommand.create((EditingDomain)domain, (Object)objectWithDanglingRefs, (Object)setting.getEStructuralFeature(), Collections.singleton(danglingReference));
                                domain.getCommandStack().execute(addThePart);
                            }
                        }
                    }
                    resource.save(null);
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                }
            }
        }
        super.saveModel();
    }

    public LayersStackApplication lookupLayerStackApplication() {
        return (LayersStackApplication)this.getModelRoot();
    }

    public LayersStackApplication getLayerStackApplication() {
        LayersStackApplication application = (LayersStackApplication)this.getModelRoot();
        if (application != null) {
            return application;
        }
        application = LayersFactory.eINSTANCE.createLayersStackApplication();
        this.addModelRoot((EObject)application);
        return application;
    }

    public void removeRoot(LayersStackApplication application) {
        this.getResource().getContents().remove((Object)application);
    }

    public LayersStackAndApplicationLifeCycleEventNotifier getLayersStackLifeCycleEventNotifier() {
        if (this.layersStackAndApplicationLifeCycleEventNotifier == null) {
            this.layersStackAndApplicationLifeCycleEventNotifier = new LayersStackAndApplicationLifeCycleEventNotifier(this);
        }
        return this.layersStackAndApplicationLifeCycleEventNotifier;
    }
}

