/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.impl.StringToTypeInstanceMapImpl;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.util.ECoreUtils;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.ILayersModelEventListener;

public class LayersModelEventNotifier {
    protected LayersStack layersStack;
    protected List<ILayersModelEventListener> listeners = new ArrayList<ILayersModelEventListener>();
    protected Adapter layersListener = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            if (Activator.log.isDebugEnabled()) {
                Activator.log.debug(String.valueOf(((Object)((Object)this)).getClass().getSimpleName()) + ".event received " + notification.getFeature());
            }
            super.notifyChanged(notification);
            if (notification.getFeature() == LayersPackage.eINSTANCE.getLayerOperator_Layers() || notification.getFeature() == LayersPackage.eINSTANCE.getLayersStack_Layers()) {
                switch (notification.getEventType()) {
                    case 1: {
                        LayersModelEventNotifier.this.fireLayerSet(notification);
                        break;
                    }
                    case 3: {
                        LayersModelEventNotifier.this.fireLayerAdded(notification);
                        break;
                    }
                    case 4: {
                        LayersModelEventNotifier.this.fireLayerRemoved(notification);
                        break;
                    }
                    case 7: {
                        LayersModelEventNotifier.this.fireLayerMoved(notification);
                    }
                }
            } else if (notification.getFeature() == LayersPackage.eINSTANCE.getAbstractLayer_Views()) {
                switch (notification.getEventType()) {
                    case 3: {
                        LayersModelEventNotifier.this.fireViewAddedToLayer(notification);
                        break;
                    }
                    case 5: {
                        LayersModelEventNotifier.this.fireMultiViewsAddedToLayer(notification);
                        break;
                    }
                    case 4: {
                        LayersModelEventNotifier.this.fireViewRemovedFromLayer(notification);
                        break;
                    }
                    case 6: {
                        LayersModelEventNotifier.this.fireMultiViewsRemovedFromLayer(notification);
                    }
                }
            } else if (notification.getFeature() == LayersPackage.eINSTANCE.getAbstractLayer_PropertyValueMap()) {
                switch (notification.getEventType()) {
                    case 3: {
                        StringToTypeInstanceMapImpl entry = (StringToTypeInstanceMapImpl)notification.getNewValue();
                        LayersModelEventNotifier.this.firePropertyValueAddedEvent(notification);
                        break;
                    }
                    case 4: {
                        StringToTypeInstanceMapImpl entry = (StringToTypeInstanceMapImpl)notification.getOldValue();
                        LayersModelEventNotifier.this.firePropertyValueRemoved(notification);
                        break;
                    }
                }
            } else if (notification.getFeature() == LayersPackage.eINSTANCE.getCSSInstance_Stylesheet()) {
                LayersModelEventNotifier.this.firePropertyValueChanged(notification);
            } else if (notification.getFeature() == LayersPackage.eINSTANCE.getCSSHideInstance_Stylesheet()) {
                LayersModelEventNotifier.this.firePropertyValueChanged(notification);
            } else if (notification.getFeature() == LayersPackage.eINSTANCE.getLayerExpression_IsLayerEnabled()) {
                LayersModelEventNotifier.this.firePropertyValueChanged(notification);
            } else {
                try {
                    TypeInstance ancestor = (TypeInstance)ECoreUtils.lookupAncestorOfType((EObject)((EObject)notification.getNotifier()), (EClass)LayersPackage.eINSTANCE.getTypeInstance());
                    AbstractLayer layer = (AbstractLayer)ECoreUtils.lookupAncestorOfType((EObject)((EObject)notification.getNotifier()), (EClass)LayersPackage.eINSTANCE.getAbstractLayer());
                    switch (notification.getEventType()) {
                        case 1: {
                            LayersModelEventNotifier.this.firePropertyValueChanged(notification);
                            break;
                        }
                        case 3: {
                            LayersModelEventNotifier.this.firePropertyValueChanged(notification);
                            break;
                        }
                        case 4: {
                            LayersModelEventNotifier.this.firePropertyValueChanged(notification);
                            break;
                        }
                    }
                }
                catch (NotFoundException notFoundException) {
                    // empty catch block
                }
            }
        }
    };

    public LayersModelEventNotifier(LayersStack layersStack) {
        this.layersStack = layersStack;
        this.activate();
    }

    public List<ILayersModelEventListener> getListeners() {
        return this.listeners;
    }

    protected void activate() {
        this.layersStack.eAdapters().add((Object)this.layersListener);
    }

    protected void deactivate() {
        this.layersStack.eAdapters().remove((Object)this.layersListener);
    }

    public void dispose() {
        this.deactivate();
        this.listeners.clear();
        this.layersListener = null;
    }

    public boolean isDisposed() {
        return this.layersListener == null;
    }

    public void addLayersModelEventListener(ILayersModelEventListener listener) {
        if (listener == null) {
            return;
        }
        if (this.listeners.contains(listener)) {
            return;
        }
        this.listeners.add(listener);
    }

    public void removeLayersModelEventListener(ILayersModelEventListener listener) {
        this.listeners.remove(listener);
    }

    public void firePropertyValueAddedEvent(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.propertyValueAdded(notification);
        }
    }

    public void firePropertyValueRemoved(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.propertyValueRemoved(notification);
        }
    }

    public void firePropertyValueChanged(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.propertyValueChanged(notification);
        }
    }

    public void fireLayerSet(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.layerSet(notification);
        }
    }

    public void fireLayerAdded(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.layerAdded(notification);
        }
    }

    public void fireLayerRemoved(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.layerRemoved(notification);
        }
    }

    public void fireLayerMoved(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.layerMoved(notification);
        }
    }

    public void fireViewAddedToLayer(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.viewAddedToLayer(notification);
        }
    }

    public void fireMultiViewsAddedToLayer(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.multiViewsAddedToLayer(notification);
        }
    }

    public void fireViewRemovedFromLayer(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.viewRemovedFromLayer(notification);
        }
    }

    public void fireMultiViewsRemovedFromLayer(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.multiViewsRemovedFromLayer(notification);
        }
    }

    public void fireViewMovedBetweenLayer(Notification notification) {
        for (ILayersModelEventListener listener : this.listeners) {
            listener.viewMovedBetweenLayer(notification);
        }
    }
}

