/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime;

import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.provider.CSSClassContentProvider;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.BadStateException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.LayersException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.NotFoundException;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.command.ComputePropertyValueCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.AbstractLayer;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersPackage;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStack;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.LayersStackApplication;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.Property;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.PropertySetter;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.layers.TypeInstance;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.DiagramViewEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.model.notifier.IDiagramViewEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.Activator;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.ILayersModelEventListener;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayersModelEventNotifier;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.LayersModelEventUtils;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands.ApplyLayerCSSChangedCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands.ApplyLayerCSSCommand;
import org.eclipse.papyrus.internal.infra.gmfdiag.layers.runtime.commands.HideLayerElementsCommand;

public class LayerStackSynchronizer
implements IDiagramViewEventListener,
ILayersModelEventListener {
    protected Diagram diagram;
    protected LayersStack layersStack;
    protected LayersStackApplication application;
    protected LayersModelEventNotifier layersModelEventNotifier;
    protected DiagramViewEventNotifier diagramViewEventNotifier;

    public LayerStackSynchronizer(LayersStack layersStack) {
        this.diagram = layersStack.getDiagram();
        this.layersStack = layersStack;
        this.application = (LayersStackApplication)layersStack.eContainer();
        this.activate();
    }

    public Diagram getDiagram() {
        return this.diagram;
    }

    public LayersStack getLayersStack() {
        return this.layersStack;
    }

    protected void activate() {
        this.diagramViewEventNotifier = new DiagramViewEventNotifier(this.diagram);
        this.diagramViewEventNotifier.addEventListener((IDiagramViewEventListener)this);
        this.layersModelEventNotifier = new LayersModelEventNotifier(this.layersStack);
        this.layersModelEventNotifier.addLayersModelEventListener(this);
    }

    protected void deactivate() {
        this.diagramViewEventNotifier.removeEventListener((IDiagramViewEventListener)this);
        this.diagramViewEventNotifier = null;
        this.layersModelEventNotifier.removeLayersModelEventListener(this);
        this.layersModelEventNotifier = null;
    }

    protected void dispose() {
        this.deactivate();
        this.diagramViewEventNotifier = null;
        this.layersModelEventNotifier = null;
    }

    protected boolean isDisposed() {
        return this.diagramViewEventNotifier == null;
    }

    protected void checkApplication() throws BadStateException {
        if (this.application == null) {
            throw new BadStateException("Attempt to call a method requireing the 'application object, but the Application object is not set. You must provide a LayerStack contained in its Application.");
        }
    }

    @Override
    public void propertyValueAdded(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueAdded " + notification.getNewValue());
        }
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueAdd(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List views = layer.getViews();
            if (views.size() == 0) {
                views = layer.getLayersStack().getDiagram().getChildren();
                return;
            }
            this.checkApplication();
            try {
                TransactionalEditingDomain ted = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)((View)views.get(0)).eResource());
                ApplyLayerCSSCommand applyLayerCSSCommand = new ApplyLayerCSSCommand(ted, views, propertyName, this.application, this.layersStack, "RecordingCommand aggregating the CSS and style applications from a single layer");
                applyLayerCSSCommand.execute();
            }
            catch (ServiceException e) {
                Activator.log.error("PropertyValueAdded applyLayerCSSCommand has failed", (Throwable)e);
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedOperationException("a setter is not implemented", e);
        }
    }

    @Override
    public void propertyValueRemoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueRemoved " + notification.getOldValue());
        }
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueRemove(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List views = layer.getViews();
            if (views.size() == 0) {
                views = layer.getLayersStack().getDiagram().getChildren();
            }
            this.checkApplication();
            Property property = this.application.getPropertyRegistry().getProperty(propertyName);
            List commands = this.layersStack.getViewsComputePropertyValueCommand(views, property);
            if (commands == null) {
                return;
            }
            PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
            int i = 0;
            while (i < views.size()) {
                TypeInstance cmd = ((ComputePropertyValueCommand)commands.get(i)).getCmdValue();
                if (cmd != null) {
                    setter.setValue((View)views.get(i), cmd.getCmdValue());
                }
                ++i;
            }
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void propertyValueChanged(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueChanged " + notification.getNewValue());
        }
        if (notification.getFeature() == LayersPackage.eINSTANCE.getLayerExpression_IsLayerEnabled()) {
            this.propertyValueChangedIsLayerEnabled(notification);
            return;
        }
        try {
            String propertyName = LayersModelEventUtils.PropertyEvents.getPropertyNameFromValueSet(notification);
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List views = layer.getViews();
            if (views.size() == 0) {
                views = layer.getLayersStack().getDiagram().getChildren();
            }
            this.checkApplication();
            try {
                TransactionalEditingDomain ted = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)layer.getLayersStack().getDiagram().eResource());
                ApplyLayerCSSChangedCommand applyLayerCSSChangedCommand = new ApplyLayerCSSChangedCommand(ted, views, propertyName, layer, this.application, this.layersStack, "RecordingCommand aggregating the CSS and style applications from a single layer");
                applyLayerCSSChangedCommand.execute();
            }
            catch (ServiceException e) {
                Activator.log.error("PropertyValueChanged applyLayerCSSChangedCommand has failed", (Throwable)e);
            }
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void propertyValueChangedIsLayerEnabled(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".propertyValueChangedIsLayerEnabled " + notification.getNewValue());
        }
        try {
            this.checkApplication();
            AbstractLayer layer = (AbstractLayer)notification.getNotifier();
            if (layer.isLayerEnabled()) {
                this.recomputePropertiesForAllViewsOf(layer);
            }
            this.setVisibility(layer);
        }
        catch (NotFoundException e) {
            Activator.log.error((Throwable)e);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void setVisibility(AbstractLayer layer) {
        try {
            TransactionalEditingDomain ted = ServiceUtilsForResource.getInstance().getTransactionalEditingDomain((Object)this.diagram.eResource());
            if (ted == null) {
                return;
            }
            ExtendedCSSEngine cssEngine = this.diagram instanceof CSSDiagram ? ((CSSDiagram)this.diagram).getEngine() : null;
            CSSClassContentProvider cssccp = new CSSClassContentProvider("*", cssEngine);
            cssccp.getAvailableClasses();
            HideLayerElementsCommand rc = new HideLayerElementsCommand(ted, layer, "HideLayerElementsCommand");
            rc.execute();
        }
        catch (ServiceException e) {
            Activator.log.error("setVisibility hideLayerElementsCommand has failed", (Throwable)e);
        }
    }

    private void recompute(List<View> views, List<Property> properties) throws LayersException {
        for (View view : views) {
            this.recompute(view, properties);
        }
    }

    private void recompute(View view, List<Property> properties) throws LayersException {
        List commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, properties);
        if (commands == null) {
            return;
        }
        int i = 0;
        while (i < commands.size()) {
            try {
                Property property = properties.get(i);
                PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                ComputePropertyValueCommand getterCmd = (ComputePropertyValueCommand)commands.get(i);
                if (getterCmd != null) {
                    setter.setValue(view, getterCmd.getCmdValue());
                }
            }
            catch (NotFoundException e) {
                Activator.log.error((Throwable)e);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ++i;
        }
    }

    @Override
    public void layerAdded(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".layerAdded() " + notification.getNewValue());
        }
        if (!(notification.getNewValue() instanceof AbstractLayer)) {
            Activator.log.info("TODO: " + this.getClass().getSimpleName() + ".layerAdded() " + notification.getOldValue() + " - recompute for LayerOperator not implemented yet.");
            return;
        }
        AbstractLayer layer = (AbstractLayer)notification.getNewValue();
        layer.setOwningLayersStack(this.layersStack);
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void layerRemoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " layerRemoved() " + notification.getOldValue());
        }
        if (!(notification.getOldValue() instanceof AbstractLayer)) {
            Activator.log.info("TODO: " + this.getClass().getSimpleName() + ".layerRemoved() " + notification.getOldValue() + " - recompute() after removing layerOperator not implemented yet.");
            return;
        }
        AbstractLayer layer = (AbstractLayer)notification.getOldValue();
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    private void recomputePropertiesForAllViewsOf(AbstractLayer layer) throws LayersException {
        List properties = layer.getAttachedProperties();
        List views = layer.getViews();
        if (views.size() == 0) {
            this.recompute((List<View>)this.diagram.getChildren(), (List<Property>)properties);
            return;
        }
        this.recompute(views, (List<Property>)properties);
    }

    @Override
    public void layerMoved(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " layerMoved(not tested) " + notification.getNewValue());
        }
        AbstractLayer layer = (AbstractLayer)notification.getNewValue();
        try {
            this.checkApplication();
            this.recomputePropertiesForAllViewsOf(layer);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void layerSet(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " layerSet(not implemented) " + notification.getNewValue());
        }
    }

    @Override
    public void viewAddedToLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " viewAddedToLayer( " + notification.getNewValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            View view = LayersModelEventUtils.ViewEvents.getViewAdded(notification);
            this.checkApplication();
            List properties = layer.getAttachedProperties();
            List commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, properties);
            if (commands == null) {
                return;
            }
            int i = 0;
            while (i < commands.size()) {
                try {
                    Property property = (Property)properties.get(i);
                    PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                    setter.setValue(view, ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                }
                catch (NotFoundException e) {
                    Activator.log.error("No setter found", (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void multiViewsAddedToLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + ".multiViewsAddedToLayer( " + notification.getNewValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List<View> views = LayersModelEventUtils.ViewEvents.getViewsAdded(notification);
            this.checkApplication();
            List properties = layer.getAttachedProperties();
            this.recompute(views, (List<Property>)properties);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void viewRemovedFromLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " viewRemovedFromLayer( " + notification.getOldValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            View view = LayersModelEventUtils.ViewEvents.getViewRemoved(notification);
            this.checkApplication();
            List properties = layer.getAttachedProperties();
            List commands = this.layersStack.getPropertiesComputePropertyValueCommand(view, properties);
            if (commands == null) {
                return;
            }
            int i = 0;
            while (i < commands.size()) {
                try {
                    Property property = (Property)properties.get(i);
                    PropertySetter setter = this.application.getPropertySetterRegistry().getPropertySetter(property);
                    setter.setValue(view, ((ComputePropertyValueCommand)commands.get(i)).getCmdValue());
                }
                catch (NotFoundException e) {
                    Activator.log.error("No setter found", (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++i;
            }
        }
        catch (LayersException e) {
            Activator.log.error("LayersException upon removind the view from the Layer", (Throwable)e);
        }
    }

    @Override
    public void multiViewsRemovedFromLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " multiViewsRemovedFromLayer( " + notification.getOldValue() + " )");
        }
        try {
            AbstractLayer layer = LayersModelEventUtils.PropertyEvents.getAbstractLayer(notification);
            List<View> views = LayersModelEventUtils.ViewEvents.getViewsRemoved(notification);
            this.checkApplication();
            List properties = layer.getAttachedProperties();
            this.recompute(views, (List<Property>)properties);
        }
        catch (LayersException e) {
            Activator.log.error((Throwable)e);
        }
    }

    @Override
    public void viewMovedBetweenLayer(Notification notification) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " viewMovedBetweenLayer(not implemented) " + notification.getNewValue());
        }
    }

    public void diagramViewAdded(Notification msg) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " diagramViewAdded(not implemented) " + msg.getNewValue());
        }
    }

    public void diagramViewRemoved(Notification msg) {
        if (Activator.log.isDebugEnabled()) {
            Activator.log.info(String.valueOf(this.getClass().getSimpleName()) + " diagramViewRemoved(not implemented) " + msg.getOldValue());
        }
    }
}

