/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr;

import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.expr.Expression;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.GenericVisitor;
import org.eclipse.papyrus.designer.languages.java.reverse.javaparser.ast.visitor.VoidVisitor;

public final class AssignExpr
extends Expression {
    private Expression target;
    private Expression value;
    private Operator op;

    public AssignExpr() {
    }

    public AssignExpr(Expression target, Expression value, Operator op) {
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(op);
    }

    public AssignExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression target, Expression value, Operator op) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setTarget(target);
        this.setValue(value);
        this.setOperator(op);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getTarget() {
        return this.target;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    public void setTarget(Expression target) {
        this.target = target;
        this.setAsParentNodeOf(this.target);
    }

    public void setValue(Expression value) {
        this.value = value;
        this.setAsParentNodeOf(this.value);
    }

    public static enum Operator {
        assign,
        plus,
        minus,
        star,
        slash,
        and,
        or,
        xor,
        rem,
        lShift,
        rSignedShift,
        rUnsignedShift;

    }
}

