/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.java.reverse.ui.dialog;

import java.util.List;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InputListDialog {
    private String message;
    private String tooltips;
    private List<String> fieldList;
    private Text addToListText;
    private org.eclipse.swt.widgets.List listWidget;

    public InputListDialog(String msg, List<String> list) {
        this.message = msg;
        this.fieldList = list;
    }

    public void setTooltips(String tooltips) {
        this.tooltips = tooltips;
    }

    public String[] getList() {
        return this.listWidget.getItems();
    }

    public Control createDialogArea(Composite parent) {
        Composite composite = parent;
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(772);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.setToolTip((Control)label, this.tooltips);
        }
        this.createButtonBar(composite);
        this.listWidget = new org.eclipse.swt.widgets.List(composite, 2832);
        GridData listData = new GridData(1808);
        listData.heightHint = 100;
        this.listWidget.setLayoutData((Object)listData);
        this.setToolTip((Control)this.listWidget, this.tooltips);
        if (this.fieldList != null) {
            for (String item : this.fieldList) {
                this.listWidget.add(item);
            }
        }
        return composite;
    }

    private void setToolTip(Control parent, String tooltips) {
        if (tooltips != null) {
            parent.setToolTipText(tooltips);
        }
    }

    protected int getInputTextStyle() {
        return 2052;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(772);
        composite.setLayoutData((Object)data);
        composite.setFont(parent.getFont());
        this.createButtonsForButtonBar(composite);
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        this.addToListText = new Text(parent, this.getInputTextStyle());
        this.setButtonLayoutData((Control)this.addToListText);
        this.addToListText.setLayoutData((Object)new GridData(800));
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText("add");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputListDialog.this.addPressed();
            }
        });
        this.setButtonLayoutData((Control)button);
        ++((GridLayout)parent.getLayout()).numColumns;
        button = new Button(parent, 8);
        button.setText("-");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputListDialog.this.removedPressed();
            }
        });
        this.setButtonLayoutData((Control)button);
        ++((GridLayout)parent.getLayout()).numColumns;
        button = new Button(parent, 8);
        button.setText("^");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputListDialog.this.upPressed();
            }
        });
        this.setButtonLayoutData((Control)button);
        ++((GridLayout)parent.getLayout()).numColumns;
        button = new Button(parent, 8);
        button.setText("v");
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                InputListDialog.this.downPressed();
            }
        });
        this.setButtonLayoutData((Control)button);
    }

    protected void addPressed() {
        System.out.println("add pressed " + this.addToListText.getText());
        String msg = this.addToListText.getText();
        if (msg.length() == 0) {
            return;
        }
        msg.trim();
        this.listWidget.add(msg);
    }

    protected void upPressed() {
        System.out.println("up pressed");
        int selectionIndex = this.listWidget.getSelectionIndex();
        if (selectionIndex > 0) {
            this.swapItems(selectionIndex - 1, selectionIndex);
            this.listWidget.setSelection(selectionIndex - 1);
        }
    }

    private void swapItems(int down, int up) {
        String tmp = this.listWidget.getItem(down);
        this.listWidget.setItem(down, this.listWidget.getItem(up));
        this.listWidget.setItem(up, tmp);
    }

    protected void downPressed() {
        System.out.println("down pressed");
        int selectionIndex = this.listWidget.getSelectionIndex();
        if (selectionIndex < this.listWidget.getItemCount() - 1) {
            this.swapItems(selectionIndex, selectionIndex + 1);
            this.listWidget.setSelection(selectionIndex + 1);
        }
    }

    protected void removedPressed() {
        System.out.println("removed pressed");
        int selectionIndex = this.listWidget.getSelectionIndex();
        String old = this.listWidget.getItem(selectionIndex);
        this.listWidget.remove(selectionIndex);
        this.addToListText.setText(old);
    }

    protected void setButtonLayoutData(Control button) {
        GridData data = new GridData(256);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = minSize.x;
        button.setLayoutData((Object)data);
    }
}

