/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.impl.ReportUtilsException;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.HtmlReport;
import org.eclipse.modisco.infra.discovery.benchmark.core.internal.reporting.internal.BenchmarkChartGeneration;
import org.eclipse.modisco.infra.discovery.benchmark.metamodel.internal.benchmark.Benchmark;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReportUtils {
    private ReportUtils() {
    }

    public static void generateReport(Benchmark benchmark, File targetFolder, List<? extends Object> arguments, boolean measureMemoryUse) throws ReportUtilsException {
        try {
            HtmlReport report = new HtmlReport((EObject)benchmark, targetFolder, arguments);
            report.doGenerate(null);
            BenchmarkChartGeneration chartGenerator = new BenchmarkChartGeneration(targetFolder, measureMemoryUse);
            chartGenerator.generateAll(benchmark);
        }
        catch (Exception e) {
            throw new ReportUtilsException(e);
        }
    }

    public static void generateReport(URI benchmarkUri, File targetFolder, List<? extends Object> arguments, boolean measureMemoryUse) throws ReportUtilsException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(benchmarkUri, true);
        ArrayList<Benchmark> benchmarks = new ArrayList<Benchmark>();
        for (EObject root : resource.getContents()) {
            if (!(root instanceof Benchmark)) continue;
            Benchmark benchmark = (Benchmark)root;
            benchmarks.add(benchmark);
        }
        if (benchmarks.isEmpty()) {
            String message = String.format("The resource '' doen't contains any Benchmark instances at its root.", benchmarkUri.toString());
            throw new ReportUtilsException(message);
        }
        if (benchmarks.size() == 1) {
            ReportUtils.generateReport((Benchmark)benchmarks.get(0), targetFolder, arguments, measureMemoryUse);
        } else {
            for (Benchmark benchmark : benchmarks) {
                ReportUtils.generateReport(benchmark, targetFolder, arguments, measureMemoryUse);
            }
        }
    }

    public static void generateReport(File benchmarkFile, File targetFolder, List<? extends Object> arguments, boolean measureMemoryUse) throws ReportUtilsException {
        URI uri = URI.createFileURI((String)benchmarkFile.getAbsolutePath());
        ReportUtils.generateReport(uri, targetFolder, arguments, measureMemoryUse);
    }
}

