/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.ui;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.JComponent;

public class JFastLabel
extends JComponent {
    private String m_text;
    private int m_valign = 1;
    private int m_halign = 2;
    private int m_fheight = -1;
    private boolean m_quality = false;

    public JFastLabel() {
        this(null);
    }

    public JFastLabel(String text) {
        this.m_text = text;
        this.setFont(this.getFont());
    }

    public String getText() {
        return this.m_text;
    }

    public void setText(String text) {
        this.m_text = text;
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.m_fheight = -1;
    }

    public void setVerticalAlignment(int align) {
        this.m_valign = align;
        this.m_fheight = -1;
    }

    public void setHorizontalAlignment(int align) {
        this.m_halign = align;
    }

    public boolean getHighQuality() {
        return this.m_quality;
    }

    public void setHighQuality(boolean b) {
        this.m_quality = b;
    }

    public void paintComponent(Graphics g) {
        FontMetrics fm;
        Insets ins = this.getInsets();
        int w = this.getWidth() - ins.left - ins.right;
        int h = this.getHeight() - ins.top - ins.bottom;
        if (this.m_fheight == -1) {
            fm = g.getFontMetrics(this.getFont());
            if (this.m_valign == 3) {
                this.m_fheight = fm.getDescent();
            } else if (this.m_valign == 1) {
                this.m_fheight = fm.getAscent();
            }
        }
        g.setColor(this.getBackground());
        g.fillRect(ins.left, ins.top, w, h);
        if (this.m_text == null) {
            return;
        }
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        h = this.m_valign == 3 ? h - this.m_fheight - ins.bottom : ins.top + this.m_fheight;
        switch (this.m_halign) {
            case 4: {
                fm = g.getFontMetrics(this.getFont());
                w = w - ins.right - fm.stringWidth(this.m_text);
                break;
            }
            case 0: {
                fm = g.getFontMetrics(this.getFont());
                w = ins.left + w / 2 - fm.stringWidth(this.m_text) / 2;
                break;
            }
            default: {
                w = ins.left;
            }
        }
        if (this.m_quality) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        g.drawString(this.m_text, w, h);
    }
}

