/*
 * Decompiled with CFR 0.152.
 */
package prefuse.data.io.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import prefuse.data.Schema;
import prefuse.data.Table;
import prefuse.data.io.DataIOException;
import prefuse.data.io.sql.DataSourceWorker;
import prefuse.data.io.sql.SQLDataHandler;
import prefuse.data.util.Index;

public class DatabaseDataSource {
    private static final Logger s_logger = Logger.getLogger(DatabaseDataSource.class.getName());
    protected Connection m_conn;
    protected Statement m_stmt;
    protected SQLDataHandler m_handler;

    DatabaseDataSource(Connection conn, SQLDataHandler handler) {
        this.m_conn = conn;
        this.m_handler = handler;
    }

    public synchronized Table getData(String query) throws DataIOException {
        return this.getData(null, query, null);
    }

    public synchronized Table getData(String query, String keyField) throws DataIOException {
        return this.getData(null, query, keyField);
    }

    public synchronized Table getData(Table t, String query) throws DataIOException {
        return this.getData(t, query, null);
    }

    public synchronized Table getData(Table t, String query, String keyField) throws DataIOException {
        return this.getData(t, query, keyField, null);
    }

    public synchronized Table getData(Table t, String query, String keyField, Object lock) throws DataIOException {
        ResultSet rs;
        try {
            rs = this.executeQuery(query);
        }
        catch (SQLException e) {
            throw new DataIOException(e);
        }
        return this.process(t, rs, keyField, lock);
    }

    public void loadData(Table t, String query) {
        this.loadData(t, query, null, null, null);
    }

    public void loadData(Table t, String query, String keyField) {
        this.loadData(t, query, keyField, null, null);
    }

    public void loadData(Table t, String query, Object lock) {
        this.loadData(t, query, null, lock, null);
    }

    public void loadData(Table t, String query, String keyField, Object lock) {
        this.loadData(t, query, keyField, lock, null);
    }

    public void loadData(Table t, String query, String keyField, Object lock, DataSourceWorker.Listener listener) {
        DataSourceWorker.Entry e = new DataSourceWorker.Entry(this, t, query, keyField, lock, listener);
        DataSourceWorker.submit(e);
    }

    private ResultSet executeQuery(String query) throws SQLException {
        if (this.m_stmt == null) {
            this.m_stmt = this.m_conn.createStatement();
        }
        long timein = System.currentTimeMillis();
        s_logger.info("Issuing query: " + query);
        ResultSet rset = this.m_stmt.executeQuery(query);
        long time = System.currentTimeMillis() - timein;
        s_logger.info("External query processing completed: " + time / 1000L + "." + time % 1000L + " seconds.");
        return rset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Table process(Table t, ResultSet rset, String key, Object lock) throws DataIOException {
        int count = 0;
        long timein = System.currentTimeMillis();
        try {
            ResultSetMetaData metadata = rset.getMetaData();
            int ncols = metadata.getColumnCount();
            if (t == null) {
                t = this.getSchema(metadata, this.m_handler).instantiate();
                if (key != null) {
                    try {
                        t.index(key);
                        s_logger.info("Indexed field: " + key);
                    }
                    catch (Exception e) {
                        s_logger.warning("Error indexing field: " + key);
                    }
                }
            }
            lock = lock == null ? t : lock;
            while (rset.next()) {
                Object object = lock;
                synchronized (object) {
                    int row = this.getExistingRow(t, rset, key);
                    if (row < 0) {
                        row = t.addRow();
                    }
                    int i = 1;
                    while (i <= ncols) {
                        this.m_handler.process(t, row, rset, i);
                        ++i;
                    }
                }
                ++count;
            }
        }
        catch (SQLException e) {
            throw new DataIOException(e);
        }
        long time = System.currentTimeMillis() - timein;
        s_logger.info("Internal query processing completed: " + count + " rows, " + time / 1000L + "." + time % 1000L + " seconds.");
        return t;
    }

    protected int getExistingRow(Table t, ResultSet rset, String keyField) throws SQLException {
        if (keyField == null) {
            return -1;
        }
        Class type = t.getColumnType(keyField);
        if (type == null) {
            return -1;
        }
        Index index = t.index(keyField);
        if (type == Integer.TYPE) {
            return index.get(rset.getInt(keyField));
        }
        if (type == Long.TYPE) {
            return index.get(rset.getLong(keyField));
        }
        if (type == Float.TYPE) {
            return index.get(rset.getFloat(keyField));
        }
        if (type == Double.TYPE) {
            return index.get(rset.getDouble(keyField));
        }
        if (!type.isPrimitive()) {
            return index.get(rset.getObject(keyField));
        }
        return -1;
    }

    public Schema getSchema(ResultSetMetaData metadata, SQLDataHandler handler) throws SQLException {
        int ncols = metadata.getColumnCount();
        Schema schema = new Schema(ncols);
        int i = 1;
        while (i <= ncols) {
            int sqlType;
            String name = metadata.getColumnName(i);
            Class type = handler.getDataType(name, sqlType = metadata.getColumnType(i));
            if (type != null) {
                schema.addColumn(name, type);
            }
            ++i;
        }
        return schema;
    }
}

