/*
 * Decompiled with CFR 0.152.
 */
package prefuse.controls;

import java.awt.geom.Point2D;
import prefuse.Display;
import prefuse.controls.ControlAdapter;

public class AbstractZoomControl
extends ControlAdapter {
    public static final double DEFAULT_MIN_SCALE = 0.001;
    public static final double DEFAULT_MAX_SCALE = 75.0;
    protected static final int ZOOM = 0;
    protected static final int MIN_ZOOM = 1;
    protected static final int MAX_ZOOM = 2;
    protected static final int NO_ZOOM = 3;
    protected double m_minScale = 0.001;
    protected double m_maxScale = 75.0;
    protected boolean m_zoomOverItem = true;

    protected int zoom(Display display, Point2D p, double zoom, boolean abs) {
        if (display.isTranformInProgress()) {
            return 3;
        }
        double scale = display.getScale();
        double result = scale * zoom;
        int status = 0;
        if (result < this.m_minScale) {
            zoom = this.m_minScale / scale;
            status = 1;
        } else if (result > this.m_maxScale) {
            zoom = this.m_maxScale / scale;
            status = 2;
        }
        if (abs) {
            display.zoomAbs(p, zoom);
        } else {
            display.zoom(p, zoom);
        }
        display.repaint();
        return status;
    }

    public double getMaxScale() {
        return this.m_maxScale;
    }

    public void setMaxScale(double maxScale) {
        this.m_maxScale = maxScale;
    }

    public double getMinScale() {
        return this.m_minScale;
    }

    public void setMinScale(double minScale) {
        this.m_minScale = minScale;
    }

    public boolean isZoomOverItem() {
        return this.m_zoomOverItem;
    }

    public void setZoomOverItem(boolean zoomOverItem) {
        this.m_zoomOverItem = zoomOverItem;
    }
}

