/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.tests;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.internal.service.tests.ConstraintListener;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.model.CategoryManager;
import org.eclipse.emf.validation.model.ConstraintSeverity;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.AbstractConstraintDescriptor;
import org.eclipse.emf.validation.service.ConstraintChangeEventType;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintListener;
import org.eclipse.emf.validation.tests.TestBase;

public class ConstraintListenersTest
extends TestBase {
    ConstraintListener listener = ConstraintListener.getInstance();
    ConstraintListenerTestConstraint registeredConstraint = new ConstraintListenerTestConstraint("registered.constraint");
    ConstraintListenerTestConstraint unregisteredConstraint = new ConstraintListenerTestConstraint("unregistered.constraint");
    Category testCategory = CategoryManager.getInstance().findCategory("junit");

    public ConstraintListenersTest(String name) {
        super(name);
    }

    public void test_registerConstraint_177656() throws ConstraintExistsException {
        ConstraintRegistry.getInstance().register((IConstraintDescriptor)this.unregisteredConstraint);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.REGISTERED, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.unregisteredConstraint), (Object)this.listener.getLastEvent().getConstraint());
    }

    public void test_unRegisterConstraint_177656() throws ConstraintExistsException {
        ConstraintRegistry.getInstance().unregister((IConstraintDescriptor)this.unregisteredConstraint);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.UNREGISTERED, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.unregisteredConstraint), (Object)this.listener.getLastEvent().getConstraint());
    }

    public void test_enableConstraint_177656() {
        this.registeredConstraint.setEnabled(false);
        this.registeredConstraint.setEnabled(true);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.ENABLED, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.registeredConstraint), (Object)this.listener.getLastEvent().getConstraint());
        this.listener.setLastEvent(null);
        this.registeredConstraint.setEnabled(true);
        ConstraintListenersTest.assertNull((String)"Enabling an enabled constraint incorrectly sent an event", (Object)this.listener.getLastEvent());
    }

    public void test_disableConstraint_177656() {
        this.registeredConstraint.setEnabled(true);
        this.registeredConstraint.setEnabled(false);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.DISABLED, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.registeredConstraint), (Object)this.listener.getLastEvent().getConstraint());
        this.listener.setLastEvent(null);
        this.registeredConstraint.setEnabled(false);
        ConstraintListenersTest.assertNull((String)"Disabling a disabled constraint incorrectly sent an event", (Object)this.listener.getLastEvent());
    }

    public void test_addCategoryToConstraint_177656() {
        this.registeredConstraint.addCategory(this.testCategory);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.ADDED_CATEGORY, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.registeredConstraint), (Object)this.listener.getLastEvent().getConstraint());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint category", (Object)this.testCategory, (Object)this.listener.getLastEvent().getCategory());
        this.listener.setLastEvent(null);
        this.registeredConstraint.addCategory(this.testCategory);
        ConstraintListenersTest.assertNull((String)"Add category for already associated category incorrectly sent an event", (Object)this.listener.getLastEvent());
    }

    public void test_removeCategoryFromConstraint_177656() {
        this.registeredConstraint.addCategory(this.testCategory);
        this.registeredConstraint.removeCategory(this.testCategory);
        if (this.listener.getLastEvent() == null) {
            ConstraintListenersTest.fail((String)"Constraint change event was null");
        }
        ConstraintListenersTest.assertSame((String)"Incorrect constraint change event", (Object)ConstraintChangeEventType.REMOVED_CATEGORY, (Object)this.listener.getLastEvent().getEventType());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint descriptor", (Object)((Object)this.registeredConstraint), (Object)this.listener.getLastEvent().getConstraint());
        ConstraintListenersTest.assertSame((String)"Incorrect constraint category", (Object)this.testCategory, (Object)this.listener.getLastEvent().getCategory());
        this.listener.setLastEvent(null);
        this.registeredConstraint.removeCategory(this.testCategory);
        ConstraintListenersTest.assertNull((String)"Remove category for non-associated category incorrectly sent an event", (Object)this.listener.getLastEvent());
    }

    protected void setUp() throws Exception {
        super.setUp();
        ConstraintRegistry.getInstance().register((IConstraintDescriptor)this.registeredConstraint);
        ConstraintRegistry.getInstance().addConstraintListener((IConstraintListener)ConstraintListener.getInstance());
        this.listener.setLastEvent(null);
        this.listener.setEnabled(true);
    }

    protected void tearDown() throws Exception {
        this.listener.setEnabled(false);
        this.listener.setLastEvent(null);
        ConstraintRegistry.getInstance().removeConstraintListener((IConstraintListener)ConstraintListener.getInstance());
        ConstraintRegistry.getInstance().unregister((IConstraintDescriptor)this.registeredConstraint);
        super.tearDown();
    }

    public class ConstraintListenerTestConstraint
    extends AbstractConstraintDescriptor
    implements IConstraintDescriptor {
        String id;

        public ConstraintListenerTestConstraint(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getPluginId() {
            return "org.eclipse.emf.validation.tests";
        }

        public String getMessagePattern() {
            return null;
        }

        public String getBody() {
            return null;
        }

        public String getName() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public ConstraintSeverity getSeverity() {
            return null;
        }

        public int getStatusCode() {
            return 0;
        }

        public EvaluationMode<?> getEvaluationMode() {
            return EvaluationMode.NULL;
        }

        public boolean targetsTypeOf(EObject eObject) {
            return false;
        }

        public boolean targetsEvent(Notification notification) {
            return false;
        }
    }
}

