/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.util.tests;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.workspace.tests.fixtures.ExternalDataOperation;
import org.eclipse.emf.workspace.util.OperationChangeDescription;

public class OperationChangeDescriptionTest
extends TestCase {
    private String[] externalData;
    private String initialValue;
    private String newValue;
    private IUndoableOperation operation;
    private OperationChangeDescription change;

    public OperationChangeDescriptionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(OperationChangeDescriptionTest.class, "Operation Change Tests");
    }

    public void test_emfChanges() {
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.getObjectChanges().isEmpty());
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.getResourceChanges().isEmpty());
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToAttach().isEmpty());
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.getObjectsToDetach().isEmpty());
    }

    public void test_canApply() {
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.canApply());
    }

    public void test_apply() {
        this.change.apply();
        OperationChangeDescriptionTest.assertEquals((String)this.initialValue, (String)this.externalData[0]);
        OperationChangeDescriptionTest.assertFalse((boolean)this.change.canApply());
    }

    public void test_applyAndReverse() {
        this.change.applyAndReverse();
        OperationChangeDescriptionTest.assertEquals((String)this.initialValue, (String)this.externalData[0]);
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.canApply());
        this.change.applyAndReverse();
        OperationChangeDescriptionTest.assertEquals((String)this.newValue, (String)this.externalData[0]);
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.canApply());
        this.change.applyAndReverse();
        OperationChangeDescriptionTest.assertEquals((String)this.initialValue, (String)this.externalData[0]);
        OperationChangeDescriptionTest.assertTrue((boolean)this.change.canApply());
    }

    protected void setUp() throws Exception {
        this.initialValue = "Initial value";
        this.newValue = "New value";
        this.externalData = new String[]{this.initialValue};
        this.operation = new ExternalDataOperation(this.externalData, this.newValue);
        this.operation.execute((IProgressMonitor)new NullProgressMonitor(), null);
        this.change = new OperationChangeDescription(this.operation, null);
        OperationChangeDescriptionTest.assertEquals((String)this.newValue, (String)this.externalData[0]);
    }

    protected void tearDown() throws Exception {
        this.externalData = null;
        this.operation = null;
        this.change = null;
        this.initialValue = null;
        this.newValue = null;
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        OperationChangeDescriptionTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }
}

