/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.elist;

import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.teneo.eclipselink.EmfHelper;
import org.eclipse.emf.teneo.eclipselink.IndirectEContainer;
import org.eclipse.emf.teneo.eclipselink.elist.EclipseLinkEList;
import org.eclipse.emf.teneo.eclipselink.internal.messages.Messages;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.indirection.UnitOfWorkQueryValueHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndirectEList<E>
extends ArrayList<E>
implements IndirectEContainer<E>,
InternalEList.Unsettable<E>,
EStructuralFeature.Setting {
    private static final long serialVersionUID = 1L;
    protected InternalEList<E> delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 10;

    public IndirectEList() {
        this(10);
    }

    public IndirectEList(int initialCapacity) {
        this(initialCapacity, 0);
    }

    public IndirectEList(int initialCapacity, int capacityIncrement) {
        super(0);
        this.initialize(initialCapacity, capacityIncrement);
    }

    public IndirectEList(Collection<? extends E> collection) {
        super(0);
        this.initialize(collection);
    }

    @Override
    public void add(int index, E element) {
        this.getDelegate().add(index, element);
        this.raiseAddChangeEvent(element);
    }

    protected void raiseAddChangeEvent(E element) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceSet(element, null);
        }
    }

    protected void raiseRemoveChangeEvent(Object object) {
        if (this.hasBeenRegistered()) {
            ((UnitOfWorkQueryValueHolder)this.getValueHolder()).updateForeignReferenceRemove(object);
        }
    }

    @Override
    public synchronized boolean add(E element) {
        this.getDelegate().add(element);
        this.raiseAddChangeEvent(element);
        return true;
    }

    @Override
    public synchronized boolean addAll(int index, Collection<? extends E> collection) {
        Iterator<E> elements = collection.iterator();
        if (this.hasBeenRegistered() || this.hasEclipseLinkPropertyChangeListener()) {
            while (elements.hasNext()) {
                this.add(index, elements.next());
                ++index;
            }
            return true;
        }
        return this.getDelegate().addAll(index, collection);
    }

    @Override
    public synchronized boolean addAll(Collection<? extends E> collection) {
        if (this.hasBeenRegistered() || this.hasEclipseLinkPropertyChangeListener()) {
            Iterator<E> elements = collection.iterator();
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return true;
        }
        return this.getDelegate().addAll(collection);
    }

    public synchronized void addElement(E element) {
        this.add(element);
    }

    protected InternalEList<E> buildDelegate() {
        return (InternalEList)this.getValueHolder().getValue();
    }

    @Override
    public void clear() {
        if (this.hasBeenRegistered() || this.hasEclipseLinkPropertyChangeListener()) {
            Iterator<E> elements = this.iterator();
            while (elements.hasNext()) {
                E element = elements.next();
                elements.remove();
                this.raiseRemoveChangeEvent(element);
            }
        } else {
            this.getDelegate().clear();
        }
    }

    @Override
    public synchronized Object clone() {
        IndirectEList result = (IndirectEList)super.clone();
        try {
            Method cloneMethod = this.getDelegate().getClass().getMethod("clone", new Class[0]);
            result.delegate = (InternalEList)cloneMethod.invoke(this.getDelegate(), new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.exception_errorInvokingCloneOnDelegate, e);
        }
        result.attributeName = null;
        result.changeListener = null;
        return result;
    }

    @Override
    public boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        return this.getDelegate().containsAll(c);
    }

    @Override
    public synchronized boolean equals(Object object) {
        return this.getDelegate().equals(object);
    }

    @Override
    public synchronized E get(int index) {
        return (E)this.getDelegate().get(index);
    }

    protected synchronized InternalEList<E> getDelegate() {
        if (this.delegate == null) {
            this.delegate = this.buildDelegate();
        }
        return this.delegate;
    }

    public synchronized ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            this.valueHolder = new ValueHolder(new EclipseLinkEList(this.initialCapacity));
        }
        return this.valueHolder;
    }

    public boolean hasBeenRegistered() {
        return this.getValueHolder() instanceof UnitOfWorkQueryValueHolder;
    }

    @Override
    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    @Override
    public int indexOf(Object object) {
        return this.getDelegate().indexOf(object);
    }

    protected void initialize(int initialCapacity, int capacityIncrement) {
        this.initialCapacity = initialCapacity;
        this.delegate = null;
        this.valueHolder = null;
    }

    protected void initialize(Collection<? extends E> collection) {
        this.delegate = null;
        EclipseLinkEList<? extends E> temp = new EclipseLinkEList<E>(collection);
        this.valueHolder = new ValueHolder(temp);
    }

    @Override
    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<E> delegateIterator;
            E currentElement;
            {
                this.delegateIterator = IndirectEList.this.getDelegate().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public E next() {
                this.currentElement = this.delegateIterator.next();
                return this.currentElement;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectEList.this.raiseRemoveChangeEvent(this.currentElement);
            }
        };
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.getDelegate().lastIndexOf(object);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListIterator<E>(index){
            ListIterator<E> delegateIterator;
            E currentElement;
            {
                this.delegateIterator = IndirectEList.this.getDelegate().listIterator(n);
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                return this.delegateIterator.hasPrevious();
            }

            @Override
            public int previousIndex() {
                return this.delegateIterator.previousIndex();
            }

            @Override
            public int nextIndex() {
                return this.delegateIterator.nextIndex();
            }

            @Override
            public E next() {
                this.currentElement = this.delegateIterator.next();
                return this.currentElement;
            }

            @Override
            public E previous() {
                this.currentElement = this.delegateIterator.previous();
                return this.currentElement;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectEList.this.raiseRemoveChangeEvent(this.currentElement);
            }

            @Override
            public void set(E element) {
                this.delegateIterator.set(element);
                IndirectEList.this.raiseRemoveChangeEvent(this.currentElement);
                IndirectEList.this.raiseAddChangeEvent(element);
            }

            @Override
            public void add(E element) {
                this.delegateIterator.add(element);
                IndirectEList.this.raiseAddChangeEvent(element);
            }
        };
    }

    @Override
    public synchronized E remove(int index) {
        Object value = this.getDelegate().remove(index);
        this.raiseRemoveChangeEvent(value);
        return (E)value;
    }

    @Override
    public boolean remove(Object object) {
        if (this.getDelegate().remove(object)) {
            this.raiseRemoveChangeEvent(object);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeAll(Collection<?> collection) {
        if (this.hasBeenRegistered() || this.hasEclipseLinkPropertyChangeListener()) {
            Iterator<?> objects = collection.iterator();
            while (objects.hasNext()) {
                this.remove(objects.next());
            }
            return true;
        }
        return this.getDelegate().removeAll(collection);
    }

    public synchronized boolean removeElement(E obj) {
        return this.remove(obj);
    }

    public synchronized void removeElementAt(int index) {
        this.remove(index);
    }

    @Override
    public synchronized boolean retainAll(Collection<?> collection) {
        if (this.hasBeenRegistered() || this.hasEclipseLinkPropertyChangeListener()) {
            Iterator elements = this.getDelegate().iterator();
            while (elements.hasNext()) {
                Object element = elements.next();
                if (collection.contains(element)) continue;
                elements.remove();
                this.raiseRemoveChangeEvent(element);
            }
            return true;
        }
        return this.getDelegate().retainAll(collection);
    }

    @Override
    public synchronized E set(int index, E element) {
        Object oldValue = this.getDelegate().set(index, element);
        this.raiseRemoveChangeEvent(oldValue);
        this.raiseAddChangeEvent(element);
        return (E)oldValue;
    }

    public synchronized void setElementAt(E obj, int index) {
        this.set(index, obj);
    }

    public void setValueHolder(ValueHolderInterface valueHolder) {
        this.valueHolder = valueHolder;
        this.delegate = null;
    }

    @Override
    public int size() {
        return this.getDelegate().size();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.getDelegate().subList(fromIndex, toIndex);
    }

    @Override
    public synchronized Object[] toArray() {
        return this.getDelegate().toArray();
    }

    @Override
    public synchronized <T> T[] toArray(T[] a) {
        return this.getDelegate().toArray((Object[])a);
    }

    @Override
    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public PropertyChangeListener getEclipseLinkPropertyChangeListener() {
        return this.changeListener;
    }

    public boolean hasEclipseLinkPropertyChangeListener() {
        return this.changeListener != null;
    }

    public void setEclipseLinkPropertyChangeListener(PropertyChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    public String getEclipseLinkAttributeName() {
        return this.attributeName;
    }

    public void setEclipseLinkAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public void move(int newPosition, E element) {
        this.getDelegate().move(newPosition, element);
        this.raiseRemoveChangeEvent(element);
        this.raiseAddChangeEvent(element);
    }

    public E move(int newPosition, int oldPosition) {
        Object element = this.getDelegate().move(newPosition, oldPosition);
        this.raiseRemoveChangeEvent(element);
        this.raiseAddChangeEvent(element);
        return (E)element;
    }

    public NotificationChain basicAdd(E element, NotificationChain notifications) {
        this.getDelegate().basicAdd(element, notifications);
        this.raiseAddChangeEvent(element);
        return notifications;
    }

    public NotificationChain basicRemove(Object object, NotificationChain notifications) {
        this.getDelegate().basicRemove(object, notifications);
        this.raiseRemoveChangeEvent(object);
        return notifications;
    }

    public Iterator<E> basicIterator() {
        return new Iterator<E>(){
            Iterator<E> delegateIterator;
            E currentElement;
            {
                this.delegateIterator = IndirectEList.this.getDelegate().basicIterator();
            }

            @Override
            public boolean hasNext() {
                return this.delegateIterator.hasNext();
            }

            @Override
            public E next() {
                this.currentElement = this.delegateIterator.next();
                return this.currentElement;
            }

            @Override
            public void remove() {
                this.delegateIterator.remove();
                IndirectEList.this.raiseRemoveChangeEvent(this.currentElement);
            }
        };
    }

    public List<E> basicList() {
        return this.getDelegate().basicList();
    }

    public ListIterator<E> basicListIterator() {
        return this.getDelegate().basicListIterator();
    }

    public ListIterator<E> basicListIterator(int index) {
        return this.getDelegate().basicListIterator(index);
    }

    public void addUnique(int index, E element) {
        this.getDelegate().addUnique(index, element);
    }

    public void addUnique(E element) {
        this.getDelegate().addUnique(element);
    }

    public E basicGet(int index) {
        return (E)this.getDelegate().basicGet(index);
    }

    public E setUnique(int index, E element) {
        return (E)this.getDelegate().setUnique(index, element);
    }

    @Override
    public void ensureCapacity(int minCapacity) {
    }

    @Override
    public void trimToSize() {
    }

    @Override
    public boolean eAdd(E element) {
        InternalEList<E> delegate = this.getDelegate();
        return EmfHelper.getInstance().addToEList(delegate, element);
    }

    public boolean isSet() {
        return ((InternalEList.Unsettable)this.getDelegate()).isSet();
    }

    public void unset() {
        ((InternalEList.Unsettable)this.getDelegate()).unset();
    }

    public EObject getEObject() {
        return ((EStructuralFeature.Setting)this.getDelegate()).getEObject();
    }

    public EStructuralFeature getEStructuralFeature() {
        return ((EStructuralFeature.Setting)this.getDelegate()).getEStructuralFeature();
    }

    public Object get(boolean resolve) {
        return ((EStructuralFeature.Setting)this.getDelegate()).get(resolve);
    }

    public void set(Object newValue) {
        ((EStructuralFeature.Setting)this.getDelegate()).set(newValue);
    }

    public boolean addAllUnique(Collection<? extends E> arg0) {
        return this.getDelegate().addAllUnique(arg0);
    }

    public boolean addAllUnique(int arg0, Collection<? extends E> arg1) {
        return this.getDelegate().addAllUnique(arg0, arg1);
    }

    public boolean basicContains(Object arg0) {
        return this.getDelegate().basicContains(arg0);
    }

    public boolean basicContainsAll(Collection<?> arg0) {
        return this.getDelegate().basicContainsAll(arg0);
    }

    public int basicIndexOf(Object arg0) {
        return this.getDelegate().basicIndexOf(arg0);
    }

    public int basicLastIndexOf(Object arg0) {
        return this.getDelegate().basicIndexOf(arg0);
    }

    public Object[] basicToArray() {
        return this.getDelegate().basicToArray();
    }

    public <T> T[] basicToArray(T[] arg0) {
        return this.getDelegate().basicToArray((Object[])arg0);
    }
}

