/*
 * Copyright (c) 2024, 2025 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.emf.cdo.lm.reviews.ui.actions;

import org.eclipse.emf.cdo.lm.client.ISystemDescriptor;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.impl.ReviewStatemachine.ReviewEvent;
import org.eclipse.emf.cdo.lm.reviews.ui.ClientReviewStatemachine;
import org.eclipse.emf.cdo.lm.reviews.ui.bundle.OM;
import org.eclipse.emf.cdo.lm.reviews.util.ReviewsOperations;
import org.eclipse.emf.cdo.lm.ui.actions.LMAction;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPage;

/**
 * @author Eike Stepper
 */
public class AbandonReviewAction extends AbstractReviewAction
{
  public AbandonReviewAction(IWorkbenchPage page, Review review)
  {
    super(page, //
        "Abandon" + INTERACTIVE, //
        "Abandon the review", //
        OM.getImageDescriptor("icons/Abandon.png"), //
        "Abandon the review.", //
        "icons/wizban/AbandonReview.png", //
        review);
  }

  @Override
  public String getAuthorizableOperationID()
  {
    return ReviewsOperations.ABANDON_REVIEW;
  }

  @Override
  protected void preRun(Review review, ISystemDescriptor systemDescriptor)
  {
  }

  @Override
  protected void fillDialogArea(LMAction<Review>.LMDialog dialog, Composite parent, Review review, ISystemDescriptor systemDescriptor)
  {
  }

  @Override
  protected void doRun(Review review, ISystemDescriptor systemDescriptor, IProgressMonitor monitor) throws Exception
  {
    ClientReviewStatemachine<Review> reviewStatemachine = ClientReviewStatemachine.of(review);
    reviewStatemachine.process(review, ReviewEvent.Abandon, null);
  }
}
