/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.DisconnectException;
import org.apache.derby.client.am.ResultSetCallbackInterface;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CodePoint;
import org.apache.derby.client.net.NetAgent;
import org.apache.derby.client.net.NetCursor;
import org.apache.derby.client.net.NetResultSet;
import org.apache.derby.client.net.NetSqlca;
import org.apache.derby.client.net.NetStatementReply;
import org.apache.derby.client.net.ResultSetReplyInterface;

class NetResultSetReply
extends NetStatementReply
implements ResultSetReplyInterface {
    NetResultSetReply(NetAgent netAgent, int bufferSize) {
        super(netAgent, bufferSize);
    }

    @Override
    public void readFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, true);
        this.endOfSameIdChainData();
    }

    @Override
    public void readPositioningFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, false);
        this.endOfSameIdChainData();
    }

    @Override
    public void readScrollableFetch(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCNTQRYreply(resultSet, true);
        this.endOfSameIdChainData();
    }

    @Override
    public void readCursorClose(ResultSetCallbackInterface resultSet) throws DisconnectException {
        this.startSameIdChainParse();
        this.parseCLSQRYreply(resultSet);
        this.endOfSameIdChainData();
    }

    private void parseCLSQRYreply(ResultSetCallbackInterface resultSet) throws DisconnectException {
        int peekCP = this.parseTypdefsOrMgrlvlovrs();
        if (peekCP == 9224) {
            NetSqlca netSqlca = this.parseSQLCARD(null);
            resultSet.completeSqlca(netSqlca);
        } else {
            this.parseCloseError(resultSet);
        }
    }

    private void parseCNTQRYreply(ResultSetCallbackInterface resultSetI, boolean doCopyQrydta) throws DisconnectException {
        boolean found = false;
        int peekCP = this.peekCodePoint();
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 9243) {
            found = true;
            if (!doCopyQrydta) {
                this.parseLengthAndMatchCodePoint(9243);
                if (this.longValueForDecryption_ != null) {
                    this.longValueForDecryption_ = null;
                }
                if (this.longBufferForDecryption_ != null) {
                    this.longBufferForDecryption_ = null;
                }
                int ddmLength = this.getDdmLength();
                this.ensureBLayerDataInBuffer(ddmLength);
                ((ClientResultSet)resultSetI).expandRowsetSqlca();
                NetSqlca sqlca = this.parseSQLCARDrow(((ClientResultSet)resultSetI).rowsetSqlca_);
                byte daNullIndicator = this.readFastByte();
                this.adjustLengths(this.getDdmLength());
                if (sqlca != null && sqlca.containsSqlcax()) {
                    ((ClientResultSet)resultSetI).setRowCountEvent(sqlca.getRowCount());
                }
                if ((peekCP = this.peekCodePoint()) == 9224) {
                    NetSqlca netSqlca = this.parseSQLCARD(((ClientResultSet)resultSetI).rowsetSqlca_);
                    resultSetI.completeSqlca(netSqlca);
                }
                if (peekCP == 8728) {
                    this.parseRDBUPDRM();
                    peekCP = this.peekCodePoint();
                }
                if (peekCP == 49152) {
                    this.parsePBSD();
                }
                return;
            }
            do {
                this.parseQRYDTA((NetResultSet)resultSetI);
            } while ((peekCP = this.peekCodePoint()) == 9243);
        }
        if (peekCP == 5228) {
            found = true;
            do {
                this.copyEXTDTA((NetCursor)((ClientResultSet)resultSetI).cursor_);
                if (this.longBufferForDecryption_ == null) continue;
                this.buffer_ = this.longBufferForDecryption_;
                this.pos_ = this.longPosForDecryption_;
                if (this.longBufferForDecryption_ == null || this.count_ <= this.longBufferForDecryption_.length) continue;
                this.count_ = this.longBufferForDecryption_.length;
            } while ((peekCP = this.peekCodePoint()) == 5228);
        }
        if (peekCP == 9224) {
            found = true;
            ((ClientResultSet)resultSetI).expandRowsetSqlca();
            NetSqlca netSqlca = this.parseSQLCARD(((ClientResultSet)resultSetI).rowsetSqlca_);
            if (((ClientResultSet)resultSetI).sensitivity_ != 3 && netSqlca != null && netSqlca.containsSqlcax() && netSqlca.getRowsetRowCount() == 0L) {
                ((ClientResultSet)resultSetI).setRowCountEvent(netSqlca.getRowCount());
            }
            resultSetI.completeSqlca(netSqlca);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8715) {
            found = true;
            this.parseEndQuery(resultSetI);
            peekCP = this.peekCodePoint();
        }
        if (peekCP == 8728) {
            found = true;
            this.parseRDBUPDRM();
            peekCP = this.peekCodePoint();
        }
        if (!found) {
            this.parseFetchError(resultSetI);
        }
        if (peekCP == 49152) {
            this.parsePBSD();
        }
        if (this.longBufferForDecryption_ != null) {
            this.buffer_ = new byte[Short.MAX_VALUE];
            this.longBufferForDecryption_ = null;
        }
    }

    private void parseCloseError(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(resultSetI);
                resultSetI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetI);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseFetchError(ResultSetCallbackInterface resultSetI) throws DisconnectException {
        int peekCP = this.peekCodePoint();
        switch (peekCP) {
            case 8717: {
                NetSqlca sqlca = this.parseAbnormalEndUow(resultSetI);
                resultSetI.completeSqlca(sqlca);
                break;
            }
            case 4692: {
                this.parseCMDCHKRM();
                break;
            }
            case 4688: {
                this.parseCMDNSPRM();
                break;
            }
            case 8706: {
                this.parseQRYNOPRM(resultSetI);
                break;
            }
            case 8708: {
                this.parseRDBNACRM();
                break;
            }
            default: {
                this.parseCommonError(peekCP);
            }
        }
    }

    private void parseQRYNOPRM(ResultSetCallbackInterface resultSet) throws DisconnectException {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        boolean pkgnamcsnReceived = false;
        Section pkgnamcsn = null;
        this.parseLengthAndMatchCodePoint(8706);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_ERROR);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8467) {
                foundInPass = true;
                pkgnamcsnReceived = this.checkAndGetReceivedFlag(pkgnamcsnReceived);
                pkgnamcsn = this.parsePKGNAMCSN(true);
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            this.doPrmnsprmSemantics(peekCP);
        }
        this.popCollectionStack();
        this.checkRequiredObjects(svrcodReceived, rdbnamReceived, pkgnamcsnReceived);
        this.netAgent_.setSvrcod(svrcod);
        if (svrcod == CodePoint.SVRCOD_WARNING) {
            this.netAgent_.accumulateReadException(new SqlException(this.netAgent_.logWriter_, new ClientMessageId("24501.S"), new Object[0]));
        } else {
            this.agent_.accumulateChainBreakingReadExceptionAndThrow(new DisconnectException(this.agent_, new ClientMessageId("08006.C"), SqlException.getMessageUtil().getTextMessage("J128", new Object[0])));
        }
    }
}

