/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.explorer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.lob.CDOBlob;
import org.eclipse.emf.cdo.common.lob.CDOClob;
import org.eclipse.emf.cdo.common.lob.CDOLobStore;
import org.eclipse.emf.cdo.common.util.CDOException;
import org.eclipse.emf.cdo.common.util.CDOResourceNodeNotFoundException;
import org.eclipse.emf.cdo.eresource.CDOBinaryResource;
import org.eclipse.emf.cdo.eresource.CDOResourceLeaf;
import org.eclipse.emf.cdo.eresource.CDOResourceNode;
import org.eclipse.emf.cdo.eresource.CDOTextResource;
import org.eclipse.emf.cdo.explorer.CDOExplorerUtil;
import org.eclipse.emf.cdo.explorer.checkouts.CDOCheckout;
import org.eclipse.emf.cdo.spi.common.util.URIHandlerFactory;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.emf.internal.cdo.view.CDOURIHandler;
import org.eclipse.net4j.util.collection.Closeable;
import org.eclipse.net4j.util.factory.ProductCreationException;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.OMPlatform;

public abstract class CDOExplorerURIHandler<NODE extends CDOResourceNode>
extends URIHandlerImpl {
    private static final boolean OMIT_CHECKOUT_FILE_URI_HANDLERS = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.explorer.omitCheckoutFileURIHandlers");
    private final String scheme;

    protected CDOExplorerURIHandler(String scheme) {
        this.scheme = scheme;
    }

    public final String getScheme() {
        return this.scheme;
    }

    public boolean canHandle(URI uri) {
        return !OMIT_CHECKOUT_FILE_URI_HANDLERS;
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        CDOView view = this.getView(uri);
        Object node = null;
        try {
            node = this.getNode(view, uri.path());
        }
        catch (CDOResourceNodeNotFoundException cDOResourceNodeNotFoundException) {
            // empty catch block
        }
        return node != null;
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        CDOView view = this.getView(uri);
        Map attributes = CDOURIHandler.getAttributes((CDOView)view, (String)uri.path(), options);
        attributes.remove("readOnly");
        return attributes;
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) throws IOException {
        CDOView view = this.getView(uri);
        NODE node = this.getNode(view, uri.path());
        return this.createInputStream(node);
    }

    public OutputStream createOutputStream(final URI uri, Map<?, ?> options) throws IOException {
        return new ByteArrayOutputStream(){

            @Override
            public void close() throws IOException {
                super.close();
                byte[] bytes = this.toByteArray();
                CDOCheckout checkout = CDOExplorerURIHandler.this.getCheckout(uri);
                CDOLobStore lobStore = checkout.getView().getSession().options().getLobCache();
                CDOExplorerURIHandler.this.modify(checkout, uri.path(), true, node -> CDOExplorerURIHandler.this.setContents(node, bytes, lobStore));
            }
        };
    }

    public void delete(URI uri, Map<?, ?> options) throws IOException {
        CDOCheckout checkout = this.getCheckout(uri);
        this.modify(checkout, uri.path(), false, node -> node.delete(options));
    }

    protected abstract NODE getNode(CDOView var1, String var2) throws CDOResourceNodeNotFoundException;

    protected abstract NODE getOrCreateNode(CDOTransaction var1, String var2);

    protected abstract void setContents(NODE var1, byte[] var2, CDOLobStore var3) throws IOException;

    protected InputStream createInputStream(NODE node) throws IOException {
        if (node instanceof CDOResourceLeaf) {
            return CDOUtil.openInputStream((CDOResourceLeaf)((CDOResourceLeaf)node));
        }
        throw new IllegalArgumentException("Not a resource leaf: " + node);
    }

    private CDOCheckout getCheckout(URI uri) {
        String id = uri.authority();
        CDOCheckout checkout = CDOExplorerUtil.getCheckout(id);
        if (checkout == null) {
            throw new CDOException("No checkout exists for " + uri);
        }
        if (!checkout.isOpen()) {
            throw new CDOException("Checkout '" + checkout.getLabel() + "' is not open");
        }
        return checkout;
    }

    private CDOView getView(URI uri) {
        CDOCheckout checkout = this.getCheckout(uri);
        return checkout.getView();
    }

    private void modify(CDOCheckout checkout, String path, boolean createOnDemand, ResourceNodeModifier<NODE> modifier) throws IOException {
        CDOTransaction transaction = null;
        try {
            try {
                transaction = checkout.openTransaction();
                NODE node = createOnDemand ? this.getOrCreateNode(transaction, path) : this.getNode((CDOView)transaction, path);
                modifier.modify(node);
                CDOCommitInfo commitInfo = transaction.commit();
                if (commitInfo != null) {
                    CDOView view = checkout.getView();
                    view.waitForUpdate(commitInfo.getTimeStamp());
                }
            }
            catch (Exception ex) {
                throw IOUtil.ioException((Exception)ex);
            }
        }
        finally {
            IOUtil.closeSilent((Closeable)transaction);
        }
    }

    private static String getScheme(CDOResourceNode node) {
        if (node instanceof CDOTextResource) {
            return "cdo.checkout.text";
        }
        if (node instanceof CDOBinaryResource) {
            return "cdo.checkout.binary";
        }
        return null;
    }

    public static URI createURI(CDOResourceNode node) {
        CDOCheckout checkout = CDOExplorerUtil.getCheckout(node);
        if (checkout == null) {
            return null;
        }
        return CDOExplorerURIHandler.createURI(checkout, node);
    }

    public static URI createURI(CDOCheckout checkout, CDOResourceNode node) {
        String scheme = CDOExplorerURIHandler.getScheme(node);
        if (scheme == null) {
            return null;
        }
        String authority = checkout.getID();
        String[] segments = node.getURI().segments();
        return URI.createHierarchicalURI((String)scheme, (String)authority, null, (String[])segments, null, null);
    }

    public static final class BinaryURIHandler
    extends CDOExplorerURIHandler<CDOBinaryResource> {
        public static final String SCHEME = "cdo.checkout.binary";

        public BinaryURIHandler() {
            super(SCHEME);
        }

        @Override
        protected CDOBinaryResource getNode(CDOView view, String path) throws CDOResourceNodeNotFoundException {
            return view.getBinaryResource(path);
        }

        @Override
        protected CDOBinaryResource getOrCreateNode(CDOTransaction transaction, String path) {
            return transaction.getOrCreateBinaryResource(path);
        }

        @Override
        protected void setContents(CDOBinaryResource node, byte[] bytes, CDOLobStore lobStore) throws IOException {
            CDOBlob blob = new CDOBlob((InputStream)new ByteArrayInputStream(bytes), lobStore);
            node.setContents(blob);
        }

        public static final class Factory
        extends URIHandlerFactory {
            public Factory() {
                super(BinaryURIHandler.SCHEME);
            }

            public URIHandler create(String description) throws ProductCreationException {
                return new BinaryURIHandler();
            }
        }
    }

    @FunctionalInterface
    private static interface ResourceNodeModifier<NODE extends CDOResourceNode> {
        public void modify(NODE var1) throws IOException;
    }

    public static final class TextURIHandler
    extends CDOExplorerURIHandler<CDOTextResource> {
        public static final String SCHEME = "cdo.checkout.text";

        public TextURIHandler() {
            super(SCHEME);
        }

        @Override
        protected CDOTextResource getNode(CDOView view, String path) throws CDOResourceNodeNotFoundException {
            return view.getTextResource(path);
        }

        @Override
        protected CDOTextResource getOrCreateNode(CDOTransaction transaction, String path) {
            return transaction.getOrCreateTextResource(path);
        }

        @Override
        protected void setContents(CDOTextResource node, byte[] bytes, CDOLobStore lobStore) throws IOException {
            String encoding = node.getEncoding();
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8.toString();
            }
            CDOClob clob = new CDOClob((Reader)new StringReader(new String(bytes, encoding)), lobStore);
            node.setContents(clob);
        }

        public static final class Factory
        extends URIHandlerFactory {
            public Factory() {
                super(TextURIHandler.SCHEME);
            }

            public URIHandler create(String description) throws ProductCreationException {
                return new TextURIHandler();
            }
        }
    }
}

