/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import javax.net.ssl.SSLException;
import org.apache.derby.impl.drda.NetworkServerControlImpl;

final class ClientThread
extends Thread {
    NetworkServerControlImpl parent;
    ServerSocket serverSocket;
    private int timeSlice;

    ClientThread(NetworkServerControlImpl nsi, ServerSocket ss) {
        super(NetworkServerControlImpl.getUniqueThreadName("NetworkServerThread"));
        this.parent = nsi;
        this.serverSocket = ss;
        this.timeSlice = nsi.getTimeSlice();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Socket clientSocket = null;
        block11: while (true) {
            try {
                while (true) {
                    try {
                        clientSocket = this.acceptClientWithRetry();
                        if (this.parent.getShutdown()) {
                            if (clientSocket != null) {
                                clientSocket.close();
                            }
                            return;
                        }
                        clientSocket.setKeepAlive(this.parent.getKeepAlive());
                        if (this.timeSlice > 0) {
                            clientSocket.setSoTimeout(this.timeSlice);
                        }
                        this.parent.addSession(clientSocket);
                        continue block11;
                    }
                    catch (InterruptedException ie) {
                        if (this.parent.getShutdown()) {
                            clientSocket.close();
                            return;
                        }
                        this.parent.consoleExceptionPrintTrace(ie);
                        if (clientSocket == null) continue;
                        clientSocket.close();
                        continue;
                    }
                    catch (SSLException ssle) {
                        this.parent.consoleExceptionPrintTrace(ssle);
                        this.parent.directShutdownInternal();
                        return;
                    }
                    catch (IOException ioe) {
                        if (clientSocket != null) {
                            clientSocket.close();
                        }
                        Object object = this.parent.getShutdownSync();
                        synchronized (object) {
                            if (this.parent.getShutdown()) {
                                return;
                            }
                        }
                        this.parent.consoleExceptionPrintTrace(ioe);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.parent.consoleExceptionPrintTrace(e);
                try {
                    if (clientSocket == null) continue;
                    clientSocket.close();
                    continue;
                }
                catch (IOException closeioe) {
                    this.parent.consoleExceptionPrintTrace(closeioe);
                    continue;
                }
            }
            break;
        }
    }

    private Socket acceptClientWithRetry() {
        for (int trycount = 1; trycount <= 3; ++trycount) {
            try {
                return this.serverSocket.accept();
            }
            catch (Exception acceptE) {
                if (this.parent.getShutdown()) continue;
                this.parent.consoleExceptionPrintTrace(acceptE);
                if (trycount == 3) {
                    this.parent.directShutdownInternal();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    this.parent.consoleExceptionPrintTrace(ie);
                }
                continue;
            }
        }
        return null;
    }
}

