/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin;

import java.io.File;
import org.eclipse.emf.cdo.server.admin.CDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.InternalCDORepositoryConfigurationManager;
import org.eclipse.emf.cdo.server.internal.admin.bundle.OM;
import org.eclipse.emf.cdo.spi.server.AbstractAppExtension;
import org.eclipse.emf.cdo.spi.server.IAppExtension5;
import org.eclipse.emf.cdo.spi.server.InternalRepository;
import org.eclipse.emf.cdo.spi.server.RepositoryFactory;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RepositoryConfigurationManagerExtension
extends AbstractAppExtension
implements IAppExtension5 {
    private static final String DEFAULT_CATALOG_PATH = "/catalog";
    private CDORepositoryConfigurationManager repositoryConfigurationManager;

    public String getName() {
        return "Repository configuration manager";
    }

    public boolean startBeforeRepositories() {
        return false;
    }

    public void start(File configFile) throws Exception {
        IPluginContainer container = IPluginContainer.INSTANCE;
        Document document = this.getDocument(configFile);
        NodeList children = document.getDocumentElement().getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            CDORepositoryConfigurationManager repositoryConfigurationManager;
            Element childElement;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && (childElement = (Element)child).getNodeName().equalsIgnoreCase("repository") && (repositoryConfigurationManager = this.configureAdminRepository((IManagedContainer)container, childElement)) != null) {
                this.repositoryConfigurationManager = repositoryConfigurationManager;
                break;
            }
            ++i;
        }
    }

    public void stop() throws Exception {
        LifecycleUtil.deactivate((Object)this.repositoryConfigurationManager);
    }

    protected CDORepositoryConfigurationManager configureAdminRepository(IManagedContainer container, Element repositoryConfig) {
        String name = repositoryConfig.getAttribute("name");
        InternalRepository repository = (InternalRepository)RepositoryFactory.get((IManagedContainer)container, (String)name);
        if (repository == null) {
            OM.LOG.warn("Repository not registered with container: " + name);
            return null;
        }
        NodeList adminRepositories = repositoryConfig.getElementsByTagName("adminRepository");
        if (adminRepositories.getLength() > 1) {
            OM.LOG.warn("A maximum of one administration catalog can be configured in repository " + repository);
            return null;
        }
        if (adminRepositories.getLength() == 1) {
            Element adminRepositoryElement = (Element)adminRepositories.item(0);
            String type = this.getAttribute(adminRepositoryElement, "configurationManager");
            if (type == null || type.length() == 0) {
                OM.LOG.warn("Repository configuration manager type not specified for repository " + repository);
                return null;
            }
            String description = this.getAttribute(adminRepositoryElement, "description");
            if (StringUtil.isEmpty((String)description)) {
                description = this.getAttribute(adminRepositoryElement, "catalogPath");
            }
            if (StringUtil.isEmpty((String)description)) {
                description = DEFAULT_CATALOG_PATH;
            }
            InternalCDORepositoryConfigurationManager repoManager = (InternalCDORepositoryConfigurationManager)container.getElement("org.eclipse.emf.cdo.server.admin.repositoryConfigurationManagers", type, description);
            repoManager.setAdminRepository(repository);
            OM.LOG.info("Admin repository: " + repository.getName());
            return repoManager;
        }
        return null;
    }
}

