/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.db;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.net4j.db.StatementBatcher;
import org.eclipse.net4j.db.ddl.IDBField;
import org.eclipse.net4j.db.ddl.IDBTable;
import org.eclipse.net4j.util.IDChanger;
import org.eclipse.net4j.util.StringUtil;

public class BatchingIDChanger
implements IDChanger.ChangeHandler {
    protected final StatementBatcher batcher;
    protected final IDBField idField;
    protected final IDBTable table;

    public BatchingIDChanger(StatementBatcher batcher, IDBField idField) {
        this(batcher, idField, idField == null ? null : idField.getTable());
    }

    public BatchingIDChanger(StatementBatcher batcher, IDBField idField, IDBTable table) {
        this.batcher = Objects.requireNonNull(batcher);
        this.idField = Objects.requireNonNull(idField);
        this.table = Objects.requireNonNull(table);
    }

    public void handleSingleChange(int oldID, int newID) {
        this.batch(newID, this.idField + "=" + oldID);
    }

    public void handleConsecutiveChanges(int firstID, int lastID, int shift) {
        this.batch(this.idField + this.shiftStr(shift), this.idField + " BETWEEN " + firstID + " AND " + lastID);
    }

    public void handleArbitraryChanges(List<Integer> affectedIDs, int shift) {
        String ids = affectedIDs.stream().map(String::valueOf).collect(Collectors.joining(","));
        this.batch(this.idField + this.shiftStr(shift), this.idField + " IN (" + ids + ")");
    }

    protected String sql(Object newValue, String condition) {
        return "UPDATE " + this.table + " SET " + this.idField + "=" + newValue + " WHERE " + condition;
    }

    protected final void batch(Object newValueExpression, String whereCondition) {
        String sql = this.sql(newValueExpression, whereCondition);
        if (!StringUtil.isEmpty((String)sql)) {
            this.batcher.batch(sql);
        }
    }

    protected final String shiftStr(int shift) {
        return shift >= 0 ? "+" + shift : String.valueOf(shift);
    }
}

