/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.ref;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class Interner<E> {
    private static final int[] PRIME_CAPACITIES = new int[]{17, 37, 67, 131, 257, 521, 1031, 2053, 4099, 8209, 16411, 32771, 65537, 131101, 262147, 524309, 0x100007, 0x200011, 0x40000F, 0x800009, 16777259, 0x2000023, 0x400000F, 134217757, 0x10000003, 0x2000000B, 0x40000003, 2147483629};
    private int size;
    private int capacityIndex;
    private Entry<E>[] entries;
    private ReferenceQueue<E> queue = new ReferenceQueue();

    public Interner() {
    }

    public Interner(int minimumCapacity) {
        this.grow(minimumCapacity);
    }

    public void grow(int minimumCapacity) {
        int currentCapacity = PRIME_CAPACITIES[this.capacityIndex];
        if (currentCapacity < minimumCapacity) {
            int i = 0;
            int length = PRIME_CAPACITIES.length;
            while (i < length) {
                int capacity = PRIME_CAPACITIES[i];
                if (capacity > minimumCapacity) {
                    this.capacityIndex = i;
                    this.rehash(this.newEntries(capacity));
                    break;
                }
                ++i;
            }
        }
    }

    public E intern(E object) {
        this.cleanup();
        int hashCode = this.hashCode(object);
        if (this.entries != null) {
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                Object otherObject;
                if (hashCode == entry.hashCode && this.equals(object, otherObject = entry.get())) {
                    return (E)otherObject;
                }
                entry = entry.next;
            }
        }
        Entry<E> entry = this.createEntry(object, hashCode);
        this.addEntry(entry);
        return object;
    }

    protected Entry<E> getEntry(int hashCode) {
        this.cleanup();
        if (this.entries != null) {
            int index = this.index(hashCode);
            Entry<E> entry = this.entries[index];
            while (entry != null) {
                if (hashCode == entry.hashCode) {
                    return entry;
                }
                entry = entry.next;
            }
        }
        return null;
    }

    protected int hashCode(E object) {
        return object.hashCode();
    }

    protected boolean equals(E object, E otherObject) {
        return object == otherObject || object.equals(otherObject);
    }

    protected Entry<E> createEntry(E object, int hashCode) {
        return new Entry<E>(object, hashCode, this.queue);
    }

    protected void addEntry(Entry<E> entry) {
        this.ensureCapacity();
        ++this.size;
        this.putEntry(entry);
    }

    private Entry<E>[] newEntries(int capacity) {
        Entry[] newEntries = new Entry[capacity];
        return newEntries;
    }

    private void ensureCapacity() {
        int capacity = PRIME_CAPACITIES[this.capacityIndex];
        if (this.entries == null) {
            this.entries = this.newEntries(capacity);
        } else if (this.size > (capacity >> 2) * 3) {
            ++this.capacityIndex;
            this.rehash(this.newEntries(PRIME_CAPACITIES[this.capacityIndex]));
        }
    }

    private void rehash(Entry<E>[] newEntries) {
        Entry<E>[] oldEntries = this.entries;
        this.entries = newEntries;
        if (oldEntries != null) {
            int i = 0;
            int length = oldEntries.length;
            while (i < length) {
                Entry<E> entry = oldEntries[i];
                while (entry != null) {
                    Entry nextEntry = entry.next;
                    this.putEntry(entry);
                    entry = nextEntry;
                }
                ++i;
            }
        }
    }

    private int index(int hashCode) {
        return (hashCode & Integer.MAX_VALUE) % this.entries.length;
    }

    private void putEntry(Entry<E> entry) {
        int index = this.index(entry.hashCode);
        Entry<E> otherEntry = this.entries[index];
        this.entries[index] = entry;
        entry.next = otherEntry;
    }

    private void cleanup() {
        Entry entry;
        while ((entry = (Entry)this.queue.poll()) != null) {
            this.removeEntry(entry);
        }
        return;
    }

    private void removeEntry(Entry<E> entry) {
        int index = this.index(entry.hashCode);
        Entry<E> otherEntry = this.entries[index];
        --this.size;
        if (entry == otherEntry) {
            this.entries[index] = entry.next;
        } else {
            Entry nextOtherEntry = otherEntry.next;
            while (nextOtherEntry != null) {
                if (nextOtherEntry == entry) {
                    otherEntry.next = entry.next;
                    break;
                }
                otherEntry = nextOtherEntry;
                nextOtherEntry = nextOtherEntry.next;
            }
        }
        entry.next = null;
        entry.clear();
    }

    protected static class Entry<E>
    extends WeakReference<E> {
        public final int hashCode;
        public Entry<E> next;

        public Entry(E object, int hashCode, ReferenceQueue<? super E> queue) {
            super(object, queue);
            this.hashCode = hashCode;
        }

        public Entry<E> getNextEntry() {
            Entry<E> entry = this.next;
            while (entry != null) {
                if (entry.hashCode == this.hashCode) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public String toString() {
            Object object = this.get();
            return object == null ? "null" : object.toString();
        }
    }
}

