/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.OutputStream;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.DataInputUtil;
import org.apache.derby.shared.common.sanity.SanityManager;

public final class StoredFieldHeader {
    private static final int FIELD_INITIAL = 0;
    public static final int FIELD_NULL = 1;
    public static final int FIELD_OVERFLOW = 2;
    private static final int FIELD_NOT_NULLABLE = 4;
    public static final int FIELD_EXTENSIBLE = 8;
    public static final int FIELD_TAGGED = 16;
    protected static final int FIELD_FIXED = 32;
    public static final int FIELD_NONEXISTENT = 5;
    public static final int STORED_FIELD_HEADER_STATUS_SIZE = 1;

    public static final boolean isNull(int status) {
        return (status & 1) == 1;
    }

    public static final boolean isOverflow(int status) {
        return (status & 2) == 2;
    }

    public static final boolean isNonexistent(int status) {
        return (status & 5) == 5;
    }

    public static final boolean isExtensible(int status) {
        return (status & 8) == 8;
    }

    public static final boolean isNullorNonExistent(int status) {
        return (status & 1) != 0;
    }

    public static final boolean isTagged(int status) {
        return (status & 0x10) == 16;
    }

    public static final boolean isFixed(int status) {
        return (status & 0x20) == 32;
    }

    public static final boolean isNullable(int status) {
        return (status & 4) == 0;
    }

    public static final int size(int status, int fieldDataLength, int fieldDataSize) {
        if ((status & 0x21) == 0) {
            if (fieldDataLength <= 63) {
                return 2;
            }
            if (fieldDataLength <= 16383) {
                return 3;
            }
            return 5;
        }
        if ((status & 1) != 0) {
            return 1;
        }
        return fieldDataSize > 2 ? 5 : 3;
    }

    public static final int setInitial() {
        return 0;
    }

    public static final int setNull(int status, boolean isNull) {
        status = isNull ? (status |= 1) : (status &= 0xFFFFFFFE);
        return status;
    }

    public static final int setOverflow(int status, boolean isOverflow) {
        status = isOverflow ? (status |= 2) : (status &= 0xFFFFFFFD);
        return status;
    }

    public static final int setNonexistent(int status) {
        return status |= 5;
    }

    public static final int setExtensible(int status, boolean isExtensible) {
        status = isExtensible ? (status |= 8) : (status &= 0xFFFFFFF7);
        return status;
    }

    public static final int setTagged(int status, boolean isTagged) {
        SanityManager.ASSERT(StoredFieldHeader.isExtensible(status), "a field cannot be set to tagged if it is not extensible");
        status = isTagged ? (status |= 0x10) : (status &= 0xFFFFFFEF);
        return status;
    }

    public static final int setFixed(int status, boolean isFixed) {
        status = isFixed ? (status |= 0x20) : (status &= 0xFFFFFFDF);
        return status;
    }

    public static final int write(OutputStream out, int status, int fieldDataLength, int fieldDataSize) throws IOException {
        int len = 1;
        out.write(status);
        if (StoredFieldHeader.isNull(status)) {
            return len;
        }
        if (StoredFieldHeader.isFixed(status)) {
            if (fieldDataSize > 2) {
                int diffLen;
                for (int i = diffLen = fieldDataSize - CompressedNumber.writeInt(out, fieldDataLength); i > 0; --i) {
                    out.write(0);
                }
                len += fieldDataSize;
            } else {
                out.write(fieldDataLength >>> 8 & 0xFF);
                out.write(fieldDataLength >>> 0 & 0xFF);
                len += 2;
            }
        } else {
            len += CompressedNumber.writeInt(out, fieldDataLength);
        }
        return len;
    }

    public static final int readStatus(ObjectInput in) throws IOException {
        int status = in.read();
        if (status >= 0) {
            return status;
        }
        throw new EOFException();
    }

    public static final int readStatus(byte[] page, int offset) {
        return page[offset];
    }

    public static final int readTotalFieldLength(byte[] data, int offset) throws IOException {
        if (StoredFieldHeader.isFixed(data[offset])) {
            SanityManager.THROWASSERT("routine does not handle FIXED.");
        }
        if ((data[offset++] & 1) != 1) {
            byte value = data[offset];
            if ((value & 0xFFFFFFC0) == 0) {
                return value + 2;
            }
            if ((value & 0x80) == 0) {
                SanityManager.ASSERT((value & 0x40) == 64);
                return ((value & 0x3F) << 8 | data[offset + 1] & 0xFF) + 3;
            }
            SanityManager.ASSERT((value & 0x80) == 128);
            return ((value & 0x7F) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF) + 5;
        }
        return 1;
    }

    public static final int readFieldLengthAndSetStreamPosition(byte[] data, int offset, int status, int fieldDataSize, ArrayInputStream ais) throws IOException {
        int fieldDataLength;
        if ((status & 0x21) == 0) {
            int value;
            if (((value = data[offset++]) & 0xFFFFFFC0) != 0) {
                if ((value & 0x80) == 0) {
                    SanityManager.ASSERT((value & 0x40) == 64);
                    value = (value & 0x3F) << 8 | data[offset++] & 0xFF;
                } else {
                    SanityManager.ASSERT((value & 0x80) == 128);
                    value = (value & 0x7F) << 24 | (data[offset++] & 0xFF) << 16 | (data[offset++] & 0xFF) << 8 | data[offset++] & 0xFF;
                }
            }
            ais.setPosition(offset);
            return value;
        }
        if ((status & 1) != 0) {
            ais.setPosition(offset);
            return 0;
        }
        if (fieldDataSize <= 2) {
            fieldDataLength = (data[offset++] & 0xFF) << 8 | data[offset++] & 0xFF;
        } else {
            fieldDataLength = data[offset];
            if ((fieldDataLength & 0xFFFFFFC0) != 0) {
                if ((fieldDataLength & 0x80) == 0) {
                    SanityManager.ASSERT((fieldDataLength & 0x40) == 64);
                    fieldDataLength = (fieldDataLength & 0x3F) << 8 | data[offset + 1] & 0xFF;
                } else {
                    SanityManager.ASSERT((fieldDataLength & 0x80) == 128);
                    fieldDataLength = (fieldDataLength & 0x7F) << 24 | (data[offset + 1] & 0xFF) << 16 | (data[offset + 2] & 0xFF) << 8 | data[offset + 3] & 0xFF;
                }
            }
            offset += fieldDataSize;
        }
        ais.setPosition(offset);
        return fieldDataLength;
    }

    public static final int readFieldDataLength(ObjectInput in, int status, int fieldDataSize) throws IOException {
        int fieldDataLength;
        if ((status & 0x21) == 0) {
            return CompressedNumber.readInt(in);
        }
        if ((status & 1) != 0) {
            return 0;
        }
        if (fieldDataSize <= 2) {
            int ch2;
            int ch1 = in.read();
            if ((ch1 | (ch2 = in.read())) < 0) {
                throw new EOFException();
            }
            fieldDataLength = (ch1 << 8) + (ch2 << 0);
        } else {
            fieldDataLength = CompressedNumber.readInt(in);
            int diffLen = fieldDataSize - CompressedNumber.sizeInt(fieldDataLength);
            if (diffLen != 0) {
                DataInputUtil.skipFully(in, diffLen);
            }
        }
        return fieldDataLength;
    }

    public static String toDebugString(int status) {
        StringBuffer str = new StringBuffer(100);
        if (StoredFieldHeader.isNull(status)) {
            str.append("Null ");
        }
        if (StoredFieldHeader.isOverflow(status)) {
            str.append("Overflow ");
        }
        if (StoredFieldHeader.isNonexistent(status)) {
            str.append("Nonexistent ");
        }
        if (StoredFieldHeader.isExtensible(status)) {
            str.append("Extensible ");
        }
        if (StoredFieldHeader.isTagged(status)) {
            str.append("Tagged ");
        }
        if (StoredFieldHeader.isFixed(status)) {
            str.append("Fixed ");
        }
        if (StoredFieldHeader.isNullable(status)) {
            str.append("Nullable ");
        }
        if (str.length() == 0) {
            str.append("INITIAL ");
        }
        return str.toString();
    }
}

