/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.bytecode;

import java.io.IOException;
import org.apache.derby.iapi.services.classfile.ClassFormatOutput;
import org.apache.derby.iapi.services.classfile.ClassHolder;
import org.apache.derby.iapi.services.classfile.ClassMember;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.services.bytecode.BCJava;
import org.apache.derby.impl.services.bytecode.BCLocalField;
import org.apache.derby.impl.services.bytecode.BCMethod;
import org.apache.derby.impl.services.bytecode.GClass;
import org.apache.derby.impl.services.bytecode.Type;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class BCClass
extends GClass {
    String limitMsg;
    protected ClassHolder classHold;
    protected String superClassName;
    protected String name;
    BCJava factory;
    final Type classType;

    @Override
    public LocalField addField(String javaType, String name, int modifiers) {
        Type type = this.factory.type(javaType);
        ClassMember field = this.classHold.addMember(name, type.vmName(), modifiers);
        int cpi = this.classHold.addFieldReference(field);
        return new BCLocalField(type, cpi);
    }

    @Override
    public ByteArray getClassBytecode() throws StandardException {
        if (this.bytecode != null) {
            return this.bytecode;
        }
        try {
            if (SanityManager.DEBUG_ON("ClassLineNumbers")) {
                ClassFormatOutput sout = new ClassFormatOutput(2);
                int cpiUTF = this.classHold.addUtf8("GC.java");
                sout.putU2(cpiUTF);
                this.classHold.addAttribute("SourceFile", sout);
            }
            this.bytecode = this.classHold.getFileFormat();
        }
        catch (IOException ioe) {
            throw StandardException.newException("XBCM1.S", ioe, this.getFullName());
        }
        this.classHold = null;
        if (SanityManager.DEBUG_ON("DumpClassFile")) {
            String systemHome = System.getProperty("derby.system.home", ".");
            this.writeClassFile(systemHome, false, null);
        }
        if (SanityManager.DEBUG_ON("ByteCodeGenInstr")) {
            SanityManager.DEBUG("ByteCodeGenInstr", "GEN complete for class " + this.name);
        }
        if (this.limitMsg != null) {
            throw StandardException.newException("XBCM4.S", this.getFullName(), this.limitMsg);
        }
        return this.bytecode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public MethodBuilder newMethodBuilder(int modifiers, String returnType, String methodName) {
        return this.newMethodBuilder(modifiers, returnType, methodName, null);
    }

    @Override
    public MethodBuilder newMethodBuilder(int modifiers, String returnType, String methodName, String[] parms) {
        SanityManager.ASSERT(returnType != null);
        BCMethod m = new BCMethod(this, returnType, methodName, modifiers, parms, this.factory);
        return m;
    }

    @Override
    public MethodBuilder newConstructorBuilder(int modifiers) {
        return new BCMethod(this, "void", "<init>", modifiers, null, this.factory);
    }

    String getSuperClassName() {
        return this.superClassName;
    }

    ClassHolder modify() {
        return this.classHold;
    }

    BCClass(ClassFactory cf, String packageName, int classModifiers, String className, String superClassName, BCJava factory) {
        super(cf, packageName.concat(className));
        if (SanityManager.DEBUG_ON("ByteCodeGenInstr")) {
            SanityManager.DEBUG("ByteCodeGenInstr", "GEN starting for class " + className);
        }
        this.name = className;
        if (superClassName == null) {
            superClassName = "java.lang.Object";
        }
        this.superClassName = superClassName;
        this.classType = factory.type(this.getFullName());
        this.classHold = new ClassHolder(this.qualifiedName, factory.type((String)superClassName).vmNameSimple, classModifiers);
        this.factory = factory;
    }

    ClassFactory getClassFactory() {
        return this.cf;
    }

    void addLimitExceeded(BCMethod mb, String limitName, int limit, int value) {
        StringBuffer sb = new StringBuffer();
        if (this.limitMsg != null) {
            sb.append(this.limitMsg);
            sb.append(", ");
        }
        sb.append("method:");
        sb.append(mb.getName());
        sb.append(" ");
        sb.append(limitName);
        sb.append(" (");
        sb.append(value);
        sb.append(" > ");
        sb.append(limit);
        sb.append(")");
        this.limitMsg = sb.toString();
    }

    void addLimitExceeded(String rawText) {
        this.limitMsg = this.limitMsg != null ? this.limitMsg + ", " + rawText : rawText;
    }
}

