/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.ws;

import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.net4j.ILocationAware;
import org.eclipse.net4j.connector.IServerConnector;
import org.eclipse.net4j.internal.ws.WSAcceptor;
import org.eclipse.net4j.internal.ws.WSConnector;

public class WSServerConnector
extends WSConnector
implements IServerConnector {
    private WSAcceptor acceptor;

    public WSServerConnector(WSAcceptor acceptor) {
        this.acceptor = acceptor;
    }

    public ILocationAware.Location getLocation() {
        return ILocationAware.Location.SERVER;
    }

    @Override
    public URI getServiceURI() {
        try {
            return this.getWebSocket().getSession().getUpgradeRequest().getRequestURI();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public String getAcceptorName() {
        try {
            return this.acceptor.getName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public WSAcceptor getAcceptor() {
        return this.acceptor;
    }

    public String getURL() {
        try {
            Object serviceURI = this.getServiceURI().toString();
            if (!((String)serviceURI).endsWith("/")) {
                serviceURI = (String)serviceURI + "/";
            }
            return (String)serviceURI + "@" + this.getAcceptorName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public String toString() {
        return MessageFormat.format("WSServerConnector[{0}]", this.getURL());
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.leaveConnecting();
    }
}

