/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.lang.reflect.Constructor;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.UserDataValue;
import org.apache.derby.impl.sql.execute.AggregatorInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class GenericAggregator {
    private final AggregatorInfo aggInfo;
    int aggregatorColumnId;
    private int inputColumnId;
    private int resultColumnId;
    private final ClassFactory cf;
    private ExecAggregator cachedAggregator;

    GenericAggregator(AggregatorInfo aggInfo, ClassFactory cf) {
        this.aggInfo = aggInfo;
        this.aggregatorColumnId = aggInfo.getAggregatorColNum();
        this.inputColumnId = aggInfo.getInputColNum();
        this.resultColumnId = aggInfo.getOutputColNum();
        this.cf = cf;
    }

    void initialize(ExecRow row) throws StandardException {
        SanityManager.ASSERT(row != null, "row is null");
        UserDataValue aggregatorColumn = (UserDataValue)row.getColumn(this.aggregatorColumnId + 1);
        ExecAggregator ua = (ExecAggregator)aggregatorColumn.getObject();
        if (ua == null) {
            ua = this.getAggregatorInstance();
            aggregatorColumn.setValue(ua);
        }
    }

    void accumulate(ExecRow inputRow, ExecRow accumulateRow) throws StandardException {
        DataValueDescriptor inputColumn = null;
        SanityManager.ASSERT(inputRow != null && accumulateRow != null, "bad accumulate call");
        DataValueDescriptor aggregatorColumn = accumulateRow.getColumn(this.aggregatorColumnId + 1);
        inputColumn = inputRow.getColumn(this.inputColumnId + 1);
        this.accumulate(inputColumn, aggregatorColumn);
    }

    void accumulate(Object[] inputRow, Object[] accumulateRow) throws StandardException {
        DataValueDescriptor inputColumn = null;
        SanityManager.ASSERT(inputRow != null && accumulateRow != null, "bad accumulate call");
        DataValueDescriptor aggregatorColumn = (DataValueDescriptor)accumulateRow[this.aggregatorColumnId];
        inputColumn = (DataValueDescriptor)inputRow[this.inputColumnId];
        this.accumulate(inputColumn, aggregatorColumn);
    }

    void accumulate(DataValueDescriptor inputColumn, DataValueDescriptor aggregatorColumn) throws StandardException {
        ExecAggregator ua;
        if (!(aggregatorColumn instanceof UserDataValue)) {
            SanityManager.THROWASSERT("accumlator column is not a UserDataValue as expected, it is a " + aggregatorColumn.getClass().getName());
        }
        if ((ua = (ExecAggregator)aggregatorColumn.getObject()) == null) {
            ua = this.getAggregatorInstance();
        }
        ua.accumulate(inputColumn, this);
    }

    void merge(ExecRow inputRow, ExecRow mergeRow) throws StandardException {
        DataValueDescriptor mergeColumn = mergeRow.getColumn(this.aggregatorColumnId + 1);
        DataValueDescriptor inputColumn = inputRow.getColumn(this.aggregatorColumnId + 1);
        this.merge(inputColumn, mergeColumn);
    }

    void merge(Object[] inputRow, Object[] mergeRow) throws StandardException {
        DataValueDescriptor mergeColumn = (DataValueDescriptor)mergeRow[this.aggregatorColumnId];
        DataValueDescriptor inputColumn = (DataValueDescriptor)inputRow[this.aggregatorColumnId];
        this.merge(inputColumn, mergeColumn);
    }

    boolean finish(ExecRow row) throws StandardException {
        DataValueDescriptor result;
        DataValueDescriptor outputColumn = row.getColumn(this.resultColumnId + 1);
        DataValueDescriptor aggregatorColumn = row.getColumn(this.aggregatorColumnId + 1);
        SanityManager.ASSERT(aggregatorColumn != null, "aggregatorColumn is null");
        SanityManager.ASSERT(outputColumn != null, "otuputColumn is null");
        SanityManager.ASSERT(aggregatorColumn instanceof UserDataValue, "accumlator column is not a UserDataValue as expected");
        ExecAggregator ua = (ExecAggregator)aggregatorColumn.getObject();
        if (ua == null) {
            ua = this.getAggregatorInstance();
        }
        if ((result = ua.getResult()) == null) {
            outputColumn.setToNull();
        } else {
            outputColumn.setValue(result);
        }
        return ua.didEliminateNulls();
    }

    ExecAggregator getAggregatorInstance() throws StandardException {
        ExecAggregator aggregatorInstance;
        if (this.cachedAggregator == null) {
            try {
                Class aggregatorClass = this.cf.loadApplicationClass(this.aggInfo.getAggregatorClassName());
                Constructor constructor = aggregatorClass.getConstructor(new Class[0]);
                Object agg = constructor.newInstance(new Object[0]);
                this.cachedAggregator = aggregatorInstance = (ExecAggregator)agg;
                aggregatorInstance.setup(this.cf, this.aggInfo.getAggregateName(), this.aggInfo.getResultDescription().getColumnInfo(0).getType());
            }
            catch (Exception e) {
                throw StandardException.unexpectedUserException(e);
            }
        } else {
            aggregatorInstance = this.cachedAggregator.newAggregator();
        }
        return aggregatorInstance;
    }

    int getColumnId() {
        return this.aggregatorColumnId;
    }

    DataValueDescriptor getInputColumnValue(ExecRow row) throws StandardException {
        return row.getColumn(this.inputColumnId + 1);
    }

    void merge(Storable aggregatorColumnIn, Storable aggregatorColumnOut) throws StandardException {
        if (!(aggregatorColumnIn instanceof UserDataValue)) {
            SanityManager.THROWASSERT("aggregatorColumnOut column is not a UserAggreator as expected, it is a " + aggregatorColumnIn.getClass().getName());
        }
        if (!(aggregatorColumnOut instanceof UserDataValue)) {
            SanityManager.THROWASSERT("aggregatorColumnIn column is not a UserAggreator as expected, it is a " + aggregatorColumnOut.getClass().getName());
        }
        ExecAggregator uaIn = (ExecAggregator)((UserDataValue)aggregatorColumnIn).getObject();
        ExecAggregator uaOut = (ExecAggregator)((UserDataValue)aggregatorColumnOut).getObject();
        uaOut.merge(uaIn);
    }

    AggregatorInfo getAggregatorInfo() {
        return this.aggInfo;
    }
}

