/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.properties.DefaultPropertyTester;
import org.eclipse.net4j.util.properties.IProperties;
import org.eclipse.net4j.util.properties.Properties;
import org.eclipse.net4j.util.properties.Property;

public class ViewProperties
extends Properties<CDOView> {
    public static final IProperties<CDOView> INSTANCE = new ViewProperties();
    private static final String CATEGORY_VIEW = "View";
    private static final String CATEGORY_SESSION = "Session";

    private ViewProperties() {
        super(CDOView.class);
        this.add((Property)new Property<CDOView>("open", "Open", "Whether this view is open or not.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return !view.isClosed();
            }
        });
        this.add((Property)new Property<CDOView>("viewID", "ID", "The ID of this view.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.getViewID();
            }
        });
        this.add((Property)new Property<CDOView>("viewURI", "URI", "The URI of this view.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.getURI();
            }
        });
        this.add((Property)new Property<CDOView>("branchName"){

            protected Object eval(CDOView view) {
                return view.getBranch().getName();
            }
        });
        this.add((Property)new Property<CDOView>("branch", "Branch", "The branch of this view.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.getBranch().getPathName();
            }
        });
        this.add((Property)new Property<CDOView>("timeStamp", "Time Stamp", "The time stamp of this view.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return CDOCommonUtil.formatTimeStamp((long)view.getTimeStamp());
            }
        });
        this.add((Property)new Property<CDOView>("lastUpdateTime", "Last Update", "The time stamp of the last passive update.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return CDOCommonUtil.formatTimeStamp((long)view.getLastUpdateTime());
            }
        });
        this.add((Property)new Property<CDOView>("rootResourcePermission", "Root Resource Permission", "The permission the current user has for the root resource of this view.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.getRootResource().cdoPermission();
            }
        });
        this.add((Property)new Property<CDOView>("readOnly", "Read-Only", "Whether this view is read-only or not.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.isReadOnly();
            }
        });
        this.add((Property)new Property<CDOView>("dirty", "Dirty", "Whether this view is dirty or not.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                return view.isDirty();
            }
        });
        this.add((Property)new Property<CDOView>("durable", "Durable", "Whether this view is durable or not.", CATEGORY_VIEW){

            protected Object eval(CDOView view) {
                if (view.getDurableLockingID() != null) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<CDOView>("sessionID", "Session ID", "The ID of the session of this view.", CATEGORY_SESSION){

            protected Object eval(CDOView view) {
                return view.getSession().getSessionID();
            }
        });
        this.add((Property)new Property<CDOView>("userID", "User ID", "The user ID of the session of this view.", CATEGORY_SESSION){

            protected Object eval(CDOView view) {
                return view.getSession().getUserID();
            }
        });
        this.add((Property)new Property<CDOView>("userAuthenticated"){

            protected Object eval(CDOView view) {
                return !StringUtil.isEmpty((String)view.getSession().getUserID());
            }
        });
        this.add((Property)new Property<CDOView>("historical"){

            protected Object eval(CDOView view) {
                if (view.getTimeStamp() != 0L) {
                    return true;
                }
                return false;
            }
        });
        this.add((Property)new Property<CDOView>("autoReleaseLocks"){

            protected Object eval(CDOView view) {
                if (view instanceof CDOTransaction) {
                    return ((CDOTransaction)view).options().isAutoReleaseLocksEnabled();
                }
                return false;
            }
        });
    }

    public static void main(String[] args) {
        new Tester().dumpContributionMarkup();
    }

    public static final class Tester
    extends DefaultPropertyTester<CDOView> {
        public static final String NAMESPACE = "org.eclipse.emf.cdo.view";

        public Tester() {
            super(NAMESPACE, INSTANCE);
        }
    }
}

