/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.examples.company.util;

import org.eclipse.emf.cdo.examples.company.CompanyPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class ReflectOnCompanyModel {
    private static final EPackage[] PACKAGES = new EPackage[]{CompanyPackage.eINSTANCE};

    public static void main(String[] args) {
        EPackage[] ePackageArray = PACKAGES;
        int n = PACKAGES.length;
        int n2 = 0;
        while (n2 < n) {
            EPackage ePackage = ePackageArray[n2];
            ReflectOnCompanyModel.reflectPackage(ePackage);
            ++n2;
        }
    }

    private static void reflectPackage(EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isInterface() || eClass.isAbstract()) continue;
            ReflectOnCompanyModel.reflectClass(eClass);
        }
        for (EPackage subPackage : ePackage.getESubpackages()) {
            ReflectOnCompanyModel.reflectPackage(subPackage);
        }
    }

    private static void reflectClass(EClass eClass) {
        for (EReference eReference : eClass.getEAllReferences()) {
            ReflectOnCompanyModel.reflectReference(eReference);
        }
    }

    private static void reflectReference(EReference eReference) {
        if (eReference.getEOpposite() == null && !eReference.isContainer() && !eReference.isContainment()) {
            EClass eClass = eReference.getEContainingClass();
            EPackage ePackage = eClass.getEPackage();
            String many = eReference.isMany() ? "  -->  MANY" : "";
            System.out.println(String.valueOf(ePackage.getName()) + "::" + eClass.getName() + "::" + eReference.getName() + many);
        }
    }
}

