/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTimeoutException;
import java.sql.SQLTransactionRollbackException;
import org.apache.derby.shared.common.error.DerbySQLIntegrityConstraintViolationException;
import org.apache.derby.shared.common.error.ExceptionFactory;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.i18n.MessageService;

public class SQLExceptionFactory
extends ExceptionFactory {
    @Override
    public SQLException getSQLException(String message, String messageId, SQLException next, int severity, Throwable t, Object ... args) {
        String sqlState = StandardException.getSQLStateFromIdentifier(messageId);
        StandardException ferry = this.wrapArgsForTransportAcrossDRDA(messageId, t, args);
        SQLException ex = sqlState.startsWith("08") ? new SQLNonTransientConnectionException(message, sqlState, severity, ferry) : (sqlState.startsWith("22") ? new SQLDataException(message, sqlState, severity, ferry) : (sqlState.startsWith("23") ? (sqlState.equals("23502") ? new SQLIntegrityConstraintViolationException(message, sqlState, severity, ferry) : (sqlState.equals("23513") ? new DerbySQLIntegrityConstraintViolationException(message, sqlState, severity, ferry, args[1], args[0]) : new DerbySQLIntegrityConstraintViolationException(message, sqlState, severity, ferry, args[0], args[1]))) : (sqlState.startsWith("28") ? new SQLInvalidAuthorizationSpecException(message, sqlState, severity, ferry) : (sqlState.startsWith("40") ? new SQLTransactionRollbackException(message, sqlState, severity, ferry) : (sqlState.startsWith("42") ? new SQLSyntaxErrorException(message, sqlState, severity, ferry) : (sqlState.startsWith("0A") ? new SQLFeatureNotSupportedException(message, sqlState, severity, ferry) : (sqlState.equals("XCL52.S".substring(0, 5)) || sqlState.equals("XBDA0.C.1".substring(0, 5)) ? new SQLTimeoutException(message, sqlState, severity, ferry) : new SQLException(message, sqlState, severity, ferry))))))));
        SQLException ferriedExceptions = ferry.getNextException();
        if (ferriedExceptions != null) {
            ex.setNextException(ferriedExceptions);
        }
        if (next != null) {
            ex.setNextException(next);
        }
        return ex;
    }

    @Override
    public final SQLException getSQLException(String messageId, SQLException next, Throwable cause, Object ... args) {
        String message = MessageService.getTextMessage(messageId, args);
        int severity = StandardException.getSeverityFromIdentifier(messageId);
        return this.getSQLException(message, messageId, next, severity, cause, args);
    }

    private StandardException wrapArgsForTransportAcrossDRDA(String messageId, Throwable cause, Object[] args) {
        StandardException se;
        if (cause instanceof StandardException && messageId.equals((se = (StandardException)cause).getMessageId())) {
            return se;
        }
        return StandardException.newException(messageId, cause, args);
    }
}

