/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.net.CcsidManager;

public class Utf8CcsidManager
extends CcsidManager {
    private static final String UTF8 = "UTF-8";
    private static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private final CharsetEncoder encoder = UTF8_CHARSET.newEncoder();

    public Utf8CcsidManager() {
        super((byte)32, (byte)46, new byte[]{-16, -15, -14, -13, -12, -11, -10, -9, -8, -7, -63, -62, -61, -60, -59, -58}, new byte[]{-57, -56, -55, -47, -46, -45, -44, -43, -42, -41, -63, -62, -61, -60, -59, -58});
    }

    @Override
    public byte[] convertFromJavaString(String sourceString, Agent agent) throws SqlException {
        try {
            ByteBuffer buf = this.encoder.encode(CharBuffer.wrap(sourceString));
            if (buf.limit() == buf.capacity()) {
                return buf.array();
            }
            byte[] bytes = new byte[buf.limit()];
            buf.get(bytes);
            return bytes;
        }
        catch (CharacterCodingException cce) {
            throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.7"), cce, new Object[0]);
        }
    }

    @Override
    public String convertToJavaString(byte[] sourceBytes, int offset, int numToConvert) {
        return new String(sourceBytes, offset, numToConvert, UTF8_CHARSET);
    }

    @Override
    public void startEncoding() {
        this.encoder.reset();
    }

    @Override
    public boolean encode(CharBuffer src, ByteBuffer dest, Agent agent) throws SqlException {
        CoderResult result = this.encoder.encode(src, dest, true);
        if (result == CoderResult.UNDERFLOW) {
            result = this.encoder.flush(dest);
        }
        if (result == CoderResult.UNDERFLOW) {
            return true;
        }
        if (result == CoderResult.OVERFLOW) {
            return false;
        }
        throw new SqlException(agent.logWriter_, new ClientMessageId("22005.S.7"), new Object[0]);
    }
}

